/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.time.impl.rap;

import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.core.VerificationProcessor;
import org.eclipse.rcptt.core.scenario.Verification;
import org.eclipse.rcptt.ecl.core.CoreFactory;
import org.eclipse.rcptt.ecl.core.Declaration;
import org.eclipse.rcptt.ecl.core.Val;
import org.eclipse.rcptt.ecl.internal.core.AbstractSession;
import org.eclipse.rcptt.ecl.internal.core.DeclarationContainer;
import org.eclipse.rcptt.ecl.runtime.BoxedValues;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.util.MathUtils;
import org.eclipse.rcptt.verifications.time.TimeVerification;

public class TimeVerificationProcessor
extends VerificationProcessor {
    private static final String START_KEY = String.valueOf(TimeVerificationProcessor.class.getName()) + "_start";
    private static final String RUN_KEY = String.valueOf(TimeVerificationProcessor.class.getName()) + "_run";

    public Object start(Verification verification, IProcess process) throws CoreException {
        TimeVerificationProcessor.putTime(process, START_KEY);
        return null;
    }

    private static void putTime(IProcess process, String key) throws CoreException {
        Val val = CoreFactory.eINSTANCE.createVal();
        val.setName(key);
        val.setValue((EObject)BoxedValues.box((long)new Date().getTime()));
        TimeVerificationProcessor.getGlobals(process).declare(val.getName(), (Declaration)val, true);
    }

    private static Date getDate(IProcess process, String key) {
        long startTime = (Long)BoxedValues.unbox((Object)((Val)TimeVerificationProcessor.getGlobals(process).lookup(key)).getValue());
        return new Date(startTime);
    }

    public Object run(Verification verification, Object data, IProcess process) throws CoreException {
        TimeVerificationProcessor.putTime(process, RUN_KEY);
        return null;
    }

    public void finish(Verification verification, Object data, IProcess process) throws CoreException {
        TimeVerification timeVerification = (TimeVerification)verification;
        String key = timeVerification.isIncludeContexts() ? START_KEY : RUN_KEY;
        Date start = TimeVerificationProcessor.getDate(process, key);
        double diff = (double)(new Date().getTime() - start.getTime()) / 1000.0;
        double goal = timeVerification.getMinutes() * 60 + timeVerification.getSeconds();
        diff = MathUtils.round((double)diff, (int)2);
        if ((goal = MathUtils.round((double)goal, (int)2)) < diff) {
            throw new CoreException((IStatus)new Status(4, ((Object)((Object)this)).getClass().getPackage().getName(), String.format("Verification '%s' failed. Expected test case execution time is %.2f second(s), but it was %.2f second(s).", verification.getName(), goal, diff)));
        }
    }

    private static DeclarationContainer getGlobals(IProcess process) {
        return ((AbstractSession)process.getSession()).getRoot().getGlobals();
    }
}

