/**
 * <copyright>
 * 
 * Copyright (c) 2015 itemis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     itemis - Initial API and implementation
 * 
 * </copyright>
 */
package org.eclipse.sphinx.emf.compare.report;

import com.google.common.base.Objects;
import java.io.ByteArrayInputStream;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sphinx.emf.compare.util.ModelCompareUtil;
import org.eclipse.sphinx.emf.util.EObjectUtil;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public abstract class AbstractModelCompareReportGenerator implements IPostProcessor {
  public static final String MODEL_DIFF_REPORT_KIND = "kind";
  
  public static final String MODEL_DIFF_REPORT_LEFT_DIFF_URI = "leftURI";
  
  public static final String MODEL_DIFF_REPORT_LEFT_DIFF_TEXT = "leftChangeText";
  
  public static final String MODEL_DIFF_REPORT_RIGHT_DIFF_URI = "rightURI";
  
  public static final String MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT = "rightChangeText";
  
  public static final String MODEL_DIFF_REPORT_TARGET_REPORT_FOLDER_NAME = "reports";
  
  protected abstract CharSequence doGenerate(final Comparison comparison);
  
  public void generate(final Comparison comparison, final IFile targetFile) {
    this.writeFile(targetFile, this.doGenerate(comparison));
  }
  
  public Notifier getLeftObject(final Comparison comparison) {
    Object _xblockexpression = null;
    {
      boolean _notEquals = (!Objects.equal(comparison, null));
      if (_notEquals) {
        boolean _isEmpty = comparison.getMatchedResources().isEmpty();
        boolean _not = (!_isEmpty);
        if (_not) {
          final MatchResource matchResource = comparison.getMatchedResources().get(0);
          return matchResource.getLeft();
        } else {
          boolean _isEmpty_1 = comparison.getMatches().isEmpty();
          boolean _not_1 = (!_isEmpty_1);
          if (_not_1) {
            final Match match = comparison.getMatches().get(0);
            return match.getLeft();
          }
        }
      }
      _xblockexpression = null;
    }
    return ((Notifier)_xblockexpression);
  }
  
  public Notifier getRightObject(final Comparison comparison) {
    Object _xblockexpression = null;
    {
      boolean _notEquals = (!Objects.equal(comparison, null));
      if (_notEquals) {
        boolean _isEmpty = comparison.getMatchedResources().isEmpty();
        boolean _not = (!_isEmpty);
        if (_not) {
          final MatchResource matchResource = comparison.getMatchedResources().get(0);
          return matchResource.getRight();
        } else {
          boolean _isEmpty_1 = comparison.getMatches().isEmpty();
          boolean _not_1 = (!_isEmpty_1);
          if (_not_1) {
            final Match match = comparison.getMatches().get(0);
            return match.getRight();
          }
        }
      }
      _xblockexpression = null;
    }
    return ((Notifier)_xblockexpression);
  }
  
  public IProject getTargetProject(final Comparison comparison) {
    boolean _notEquals = (!Objects.equal(comparison, null));
    if (_notEquals) {
      boolean _isEmpty = comparison.getMatchedResources().isEmpty();
      if (_isEmpty) {
        EList<Match> _matches = comparison.getMatches();
        for (final Match match : _matches) {
          {
            IFile file = EcorePlatformUtil.getFile(match.getLeft());
            boolean _equals = Objects.equal(file, null);
            if (_equals) {
              file = EcorePlatformUtil.getFile(match.getRight());
            }
            boolean _notEquals_1 = (!Objects.equal(file, null));
            if (_notEquals_1) {
              return file.getProject();
            }
          }
        }
      } else {
        EList<MatchResource> _matchedResources = comparison.getMatchedResources();
        for (final MatchResource matchResource : _matchedResources) {
          {
            IFile file = EcorePlatformUtil.getFile(matchResource.getLeft());
            boolean _equals = Objects.equal(file, null);
            if (_equals) {
              file = EcorePlatformUtil.getFile(matchResource.getRight());
            }
            boolean _notEquals_1 = (!Objects.equal(file, null));
            if (_notEquals_1) {
              return file.getProject();
            }
          }
        }
      }
    }
    return null;
  }
  
  public String getModelCompareInputText(final Object object) {
    String label = "";
    if ((object instanceof EObject)) {
      final URI uri = EcoreResourceUtil.getURI(((EObject)object), true);
      label = uri.trimQuery().toString();
    } else {
      if ((object instanceof Resource)) {
        label = ((Resource)object).getURI().trimQuery().toString();
      }
    }
    return label;
  }
  
  public String getName(final Object object) {
    String name = "";
    if ((object instanceof EObject)) {
      final EStructuralFeature eStructuralFeature = EObjectUtil.getEStructuralFeature(((EObject)object).eClass(), "name");
      boolean _notEquals = (!Objects.equal(eStructuralFeature, null));
      if (_notEquals) {
        Object _eGet = ((EObject)object).eGet(eStructuralFeature, false);
        String _string = null;
        if (_eGet!=null) {
          _string=_eGet.toString();
        }
        name = _string;
      } else {
        String _name = ((EObject)object).eClass().getName();
        String _plus = (_name + "@");
        String _hexString = Integer.toHexString(((EObject)object).hashCode());
        String _plus_1 = (_plus + _hexString);
        name = _plus_1;
      }
    } else {
      if ((object instanceof Resource)) {
        name = ((Resource)object).getURI().trimQuery().lastSegment();
      }
    }
    return name;
  }
  
  public String getDiffKindText(final Diff diff) {
    DifferenceKind _kind = null;
    if (diff!=null) {
      _kind=diff.getKind();
    }
    final DifferenceKind kind = _kind;
    boolean _equals = Objects.equal(kind, DifferenceKind.DELETE);
    if (_equals) {
      if ((diff instanceof ReferenceChange)) {
        final EReference reference = ((ReferenceChange)diff).getReference();
        boolean _isContainment = reference.isContainment();
        if (_isContainment) {
          return "DELETED from ";
        } else {
          return "REMOVED from ";
        }
      }
    } else {
      boolean _equals_1 = Objects.equal(kind, DifferenceKind.ADD);
      if (_equals_1) {
        return "ADDED to ";
      }
    }
    return (kind + "D ");
  }
  
  public String getDiffKindLabel(final DifferenceKind kind) {
    if (kind != null) {
      switch (kind) {
        case ADD:
          return "+-";
        case DELETE:
          return "-+";
        case CHANGE:
          return "<>";
        case MOVE:
          return "~";
        default:
          return "<>";
      }
    } else {
      return "<>";
    }
  }
  
  public Map<String, Object> handleDifferences(final Comparison comparison, final Diff diff) {
    Map<String, Object> map = CollectionLiterals.<String, Object>newHashMap();
    boolean _notEquals = (!Objects.equal(diff, null));
    if (_notEquals) {
      final DifferenceKind kind = diff.getKind();
      map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_KIND, this.getDiffKindLabel(kind));
      map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_LEFT_DIFF_URI, this.getDiffObjectURIFragment(diff, DifferenceSource.LEFT));
      map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_RIGHT_DIFF_URI, this.getDiffObjectURIFragment(diff, DifferenceSource.RIGHT));
      if ((diff instanceof AttributeChange)) {
        map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_LEFT_DIFF_TEXT, this.getAttributeChangeText(((AttributeChange)diff)));
        map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT, this.getAttributeChangeText(((AttributeChange)diff)));
      } else {
        DifferenceSource _source = diff.getSource();
        boolean _equals = Objects.equal(_source, DifferenceSource.LEFT);
        if (_equals) {
          boolean _equals_1 = Objects.equal(kind, DifferenceKind.ADD);
          if (_equals_1) {
            map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_LEFT_DIFF_TEXT, this.getReferenceChangeText(diff, false));
            map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT, this.getReferenceChangeText(diff, true));
          } else {
            boolean _equals_2 = Objects.equal(kind, DifferenceKind.DELETE);
            if (_equals_2) {
              map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_LEFT_DIFF_TEXT, this.getReferenceChangeText(diff, false));
              map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT, this.getReferenceChangeText(diff, true));
            } else {
              boolean _equals_3 = Objects.equal(kind, DifferenceKind.MOVE);
              if (_equals_3) {
                map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_LEFT_DIFF_TEXT, this.getReferenceChangeText(diff, false));
                map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT, this.getReferenceChangeText(diff, true));
              }
            }
          }
        } else {
          boolean _equals_4 = Objects.equal(kind, DifferenceKind.ADD);
          if (_equals_4) {
            map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_LEFT_DIFF_TEXT, this.getReferenceChangeText(diff, true));
            map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT, this.getReferenceChangeText(diff, false));
          } else {
            boolean _equals_5 = Objects.equal(kind, DifferenceKind.DELETE);
            if (_equals_5) {
              map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_LEFT_DIFF_TEXT, this.getReferenceChangeText(diff, true));
              map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT, this.getReferenceChangeText(diff, false));
            } else {
              boolean _equals_6 = Objects.equal(kind, DifferenceKind.MOVE);
              if (_equals_6) {
                map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_LEFT_DIFF_TEXT, this.getReferenceChangeText(diff, true));
                map.put(AbstractModelCompareReportGenerator.MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT, this.getReferenceChangeText(diff, false));
              }
            }
          }
        }
      }
    }
    return map;
  }
  
  public StringBuffer getDiffObjectURIFragment(final Diff diff, final DifferenceSource source) {
    StringBuffer _xblockexpression = null;
    {
      StringBuffer label = new StringBuffer();
      EObject value = null;
      if ((diff instanceof AttributeChange)) {
        final Match match = ((AttributeChange)diff).getMatch();
        EObject _xifexpression = null;
        boolean _equals = Objects.equal(source, DifferenceSource.LEFT);
        if (_equals) {
          _xifexpression = match.getLeft();
        } else {
          _xifexpression = match.getRight();
        }
        value = _xifexpression;
      } else {
        if ((diff instanceof ReferenceChange)) {
          value = ModelCompareUtil.getValue(((ReferenceChange)diff).getMatch().getComparison(), diff);
        }
      }
      boolean _notEquals = (!Objects.equal(value, null));
      if (_notEquals) {
        URI _uRI = EcoreResourceUtil.getURI(value);
        String _fragment = null;
        if (_uRI!=null) {
          _fragment=_uRI.fragment();
        }
        label.append(_fragment);
      }
      _xblockexpression = label;
    }
    return _xblockexpression;
  }
  
  public StringBuffer getAttributeChangeText(final AttributeChange attributeChange) {
    StringBuffer _xblockexpression = null;
    {
      StringBuffer label = new StringBuffer();
      boolean _notEquals = (!Objects.equal(attributeChange, null));
      if (_notEquals) {
        EAttribute _attribute = attributeChange.getAttribute();
        String _name = null;
        if (_attribute!=null) {
          _name=_attribute.getName();
        }
        String _plus = ("[" + _name);
        String _plus_1 = (_plus + " ");
        DifferenceKind _kind = attributeChange.getKind();
        String _plus_2 = (_plus_1 + _kind);
        String _plus_3 = (_plus_2 + "D");
        String _plus_4 = (_plus_3 + "]");
        label.append(_plus_4);
      }
      _xblockexpression = label;
    }
    return _xblockexpression;
  }
  
  public StringBuffer getReferenceChangeText(final Diff diff, final boolean opposite) {
    StringBuffer _xblockexpression = null;
    {
      StringBuffer label = new StringBuffer();
      if ((diff instanceof ReferenceChange)) {
        final DifferenceKind kind = ((ReferenceChange)diff).getKind();
        String kindLabel = "";
        if ((!opposite)) {
          kindLabel = this.getDiffKindText(diff);
        } else {
          boolean _equals = Objects.equal(kind, DifferenceKind.ADD);
          if (_equals) {
            kindLabel = "DELETED from ";
            final EReference reference = ((ReferenceChange)diff).getReference();
            boolean _isContainment = reference.isContainment();
            boolean _not = (!_isContainment);
            if (_not) {
              kindLabel = "REMOVED from ";
            }
          } else {
            boolean _equals_1 = Objects.equal(kind, DifferenceKind.DELETE);
            if (_equals_1) {
              kindLabel = "ADDED to ";
            } else {
              String _plus = (kind + "D ");
              kindLabel = _plus;
            }
          }
        }
        EObject _xifexpression = null;
        if ((!opposite)) {
          _xifexpression = ((ReferenceChange)diff).getMatch().getLeft();
        } else {
          _xifexpression = ((ReferenceChange)diff).getMatch().getRight();
        }
        final EObject matchValue = _xifexpression;
        StringBuffer _append = label.append(" [").append(kindLabel);
        String _name = this.getName(matchValue);
        String _plus_1 = (_name + ".");
        EReference _reference = ((ReferenceChange)diff).getReference();
        String _name_1 = null;
        if (_reference!=null) {
          _name_1=_reference.getName();
        }
        String _plus_2 = (_plus_1 + _name_1);
        return _append.append(_plus_2).append("]");
      }
      _xblockexpression = label;
    }
    return _xblockexpression;
  }
  
  public void writeFile(final IFile targetFile, final CharSequence content) {
    try {
      final NullProgressMonitor monitor = new NullProgressMonitor();
      boolean _exists = targetFile.exists();
      if (_exists) {
        targetFile.delete(true, monitor);
      }
      byte[] _bytes = content.toString().getBytes();
      ByteArrayInputStream _byteArrayInputStream = new ByteArrayInputStream(_bytes);
      targetFile.create(_byteArrayInputStream, true, monitor);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public void createFolder(final IFolder folder) {
    try {
      final NullProgressMonitor monitor = new NullProgressMonitor();
      boolean _exists = folder.exists();
      boolean _not = (!_exists);
      if (_not) {
        folder.create(true, false, monitor);
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Override
  public void postComparison(final Comparison comparison, final Monitor monitor) {
  }
  
  @Override
  public void postConflicts(final Comparison comparison, final Monitor monitor) {
  }
  
  @Override
  public void postDiff(final Comparison comparison, final Monitor monitor) {
  }
  
  @Override
  public void postEquivalences(final Comparison comparison, final Monitor monitor) {
  }
  
  @Override
  public void postMatch(final Comparison comparison, final Monitor monitor) {
  }
  
  @Override
  public void postRequirements(final Comparison comparison, final Monitor monitor) {
  }
}
