/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.testutils.integration.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.sphinx.platform.util.StatusUtil;
import org.eclipse.sphinx.testutils.TestFileAccessor;
import org.eclipse.sphinx.testutils.integration.internal.Activator;

public class ReferenceWorkspaceExtractor {
    private File extractedWorkspaceRootDirectory = null;

    public File getExtractedWorkspaceRootDirectory() {
        return this.extractedWorkspaceRootDirectory;
    }

    public void extract(TestFileAccessor inputFileAccessor, String referenceWorkspaceArchiveFileName, File targetDirectory) throws CoreException {
        Assert.isNotNull((Object)inputFileAccessor);
        try {
            URI archiveURI = inputFileAccessor.getInputFileURI(referenceWorkspaceArchiveFileName, true);
            ZipFile zipFile = new ZipFile(archiveURI.getPath());
            this.extractedWorkspaceRootDirectory = this.extract(zipFile, targetDirectory);
        }
        catch (Exception ex) {
            throw new CoreException(StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex));
        }
    }

    private File extract(ZipFile zipFile, File targetDirectory) throws IOException {
        Assert.isNotNull((Object)zipFile);
        Assert.isNotNull((Object)targetDirectory);
        File workspaceRootDirectory = null;
        Enumeration<? extends ZipEntry> en = zipFile.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            if (entry.isDirectory()) continue;
            File targetResource = new File(targetDirectory, entry.toString());
            File targetResourceDirectory = targetResource.getParentFile();
            if (!targetResourceDirectory.exists()) {
                targetResourceDirectory.mkdirs();
            }
            if (workspaceRootDirectory == null && ".project".equals(targetResource.getName())) {
                workspaceRootDirectory = targetResourceDirectory.getParentFile();
            }
            try (InputStream in = null;){
                in = zipFile.getInputStream(entry);
                this.saveInputStreamToFile(in, targetResource);
            }
        }
        return workspaceRootDirectory;
    }

    private void saveInputStreamToFile(InputStream in, File targetFile) throws IOException {
        try (FileOutputStream out = new FileOutputStream(targetFile);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
    }
}

