/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.loading.operations;

import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.workspace.internal.messages.Messages;
import org.eclipse.sphinx.emf.workspace.loading.operations.AbstractProjectLoadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.IProjectLoadOperation;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;

public class DefaultProjectLoadOperation
extends AbstractProjectLoadOperation
implements IProjectLoadOperation {
    public DefaultProjectLoadOperation(Collection<IProject> projects, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor) {
        super(mmDescriptor != null ? Messages.job_loadingModel : Messages.job_loadingModels, projects, includeReferencedProjects, mmDescriptor);
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        this.runLoadProjects(this.getProjects(), this.isIncludeReferencedProjects(), this.getMetaModelDescriptor(), monitor);
    }

    protected void runLoadProjects(Collection<IProject> projects, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull(projects);
        for (IProject project : projects) {
            String taskName = mmDescriptor != null ? NLS.bind((String)Messages.task_loadingModelInProject, (Object)mmDescriptor.getName(), (Object)project.getName()) : NLS.bind((String)Messages.task_loadingModelsInProject, (Object)project.getName());
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)taskName, (int)100);
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            Collection files = ExtendedPlatform.getAllFiles((IProject)project, (boolean)includeReferencedProjects);
            progress.worked(1);
            if (files.size() == 0) {
                progress.done();
                continue;
            }
            this.runDetectAndLoadModelFiles(files, mmDescriptor, (IProgressMonitor)progress.newChild(99));
        }
    }
}

