/**
 * <copyright>
 * 
 * Copyright (c) 2014 itemis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     itemis - Initial API and implementation
 * 
 * </copyright>
 */
package org.eclipse.sphinx.examples.workflows.longrunning;

import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.sphinx.emf.mwe.dynamic.components.AbstractWorkspaceWorkflowComponent;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IntegerRange;

@SuppressWarnings("all")
public class LongRunningWorkflowComponent extends AbstractWorkspaceWorkflowComponent {
  @Override
  protected void invokeInternal(final WorkflowContext ctx, final ProgressMonitor monitor, final Issues issues) {
    try {
      InputOutput.<String>println("Executing long running workflow component");
      try {
        monitor.beginTask("Some long running task", 10);
        boolean _isCanceled = monitor.isCanceled();
        if (_isCanceled) {
          throw new OperationCanceledException();
        }
        IntegerRange _upTo = new IntegerRange(1, 10);
        for (final Integer i : _upTo) {
          {
            Thread.sleep(1000);
            String _plus = (i + "/10 done");
            InputOutput.<String>println(_plus);
            monitor.worked(1);
            boolean _isCanceled_1 = monitor.isCanceled();
            if (_isCanceled_1) {
              throw new OperationCanceledException();
            }
          }
        }
      } finally {
        monitor.done();
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
