/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.ui.views;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sphinx.emf.ui.util.EcoreUIUtil;
import org.eclipse.sphinx.emf.validation.markers.util.MarkerUtil;
import org.eclipse.sphinx.emf.validation.ui.SphinxValidationUiActivator;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerMessages;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerSelectionProviderAction;
import org.eclipse.sphinx.emf.validation.ui.views.ProblemMarker;
import org.eclipse.sphinx.emf.validation.ui.views.Util;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public class ActionOpenMarker
extends MarkerSelectionProviderAction {
    private final String IMAGE_PATH = "elcl16/gotoobj_tsk.gif";
    private final String DISABLED_IMAGE_PATH = "dlcl16/gotoobj_tsk.gif";
    protected IWorkbenchPart part;
    protected IEditorInput editorInput;
    protected String editorId;

    public ActionOpenMarker(IWorkbenchPart part, ISelectionProvider provider) {
        super(provider, MarkerMessages.openAction_title);
        this.part = part;
        this.setImageDescriptor(IDEWorkbenchPlugin.getIDEImageDescriptor((String)"elcl16/gotoobj_tsk.gif"));
        this.setDisabledImageDescriptor(IDEWorkbenchPlugin.getIDEImageDescriptor((String)"dlcl16/gotoobj_tsk.gif"));
        this.setEnabled(false);
    }

    public void run() {
        if (this.editorInput != null && this.editorId != null) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                page.openEditor(this.editorInput, this.editorId);
            }
            catch (PartInitException ex) {
                PlatformLogUtil.logAsError((Plugin)SphinxValidationUiActivator.getDefault(), (Object)((Object)ex));
            }
        } else {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = this.getSelectedMarkers();
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorInput input;
                IFile file;
                IMarker marker = iMarkerArray[n2];
                IEditorPart editor = this.part.getSite().getPage().getActiveEditor();
                if (editor != null && (file = ResourceUtil.getFile((IEditorInput)(input = editor.getEditorInput()))) != null && marker.getResource().equals((Object)file)) {
                    this.part.getSite().getPage().activate((IWorkbenchPart)editor);
                }
                if (marker.getResource() instanceof IFile) {
                    try {
                        IFile file2 = (IFile)marker.getResource();
                        if (file2.getLocation() == null || file2.getLocationURI() == null) {
                            return;
                        }
                        IDE.openEditor((IWorkbenchPage)this.part.getSite().getPage(), (IMarker)marker, (boolean)OpenStrategy.activateOnOpen());
                    }
                    catch (PartInitException e) {
                        CoreException nestedException = null;
                        IStatus status = e.getStatus();
                        if (status != null && status.getException() instanceof CoreException) {
                            nestedException = (CoreException)status.getException();
                        }
                        if (nestedException != null) {
                            this.reportStatus(nestedException.getStatus());
                        }
                        this.reportError(e.getLocalizedMessage());
                    }
                }
                ++n2;
            }
        }
    }

    private void reportError(String message) {
        Status status = new Status(4, "org.eclipse.ui.ide", message);
        this.reportStatus((IStatus)status);
    }

    private void reportStatus(IStatus status) {
        StatusAdapter adapter = new StatusAdapter(status);
        adapter.setProperty(StatusAdapter.TITLE_PROPERTY, (Object)MarkerMessages.OpenMarker_errorTitle);
        StatusManager.getManager().handle(adapter, 2);
    }

    public void selectionChanged(IStructuredSelection selection) {
        Object element;
        this.setEnabled(Util.allConcreteSelection(selection));
        this.editorInput = null;
        this.editorId = null;
        if (selection.size() == 1 && (element = selection.getFirstElement()) instanceof ProblemMarker) {
            ProblemMarker pm = (ProblemMarker)element;
            EObject eobject = MarkerUtil.getConnectedEObjectFromMarker((IMarker)pm.getMarker());
            this.editorInput = EcoreUIUtil.createURIEditorInput((Object)eobject);
            IEditorDescriptor defaultEditor = EcoreUIUtil.getDefaultEditor((Object)eobject);
            if (defaultEditor != null) {
                this.editorId = defaultEditor.getId();
            }
        }
    }
}

