/**
 * <copyright>
 * 
 * Copyright (c) 2014 itemis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     itemis - Initial API and implementation
 * 
 * </copyright>
 */
package org.eclipse.sphinx.jdt.util;

import com.google.common.base.Objects;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import org.eclipse.sphinx.jdt.loaders.ProjectClassLoader;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class ClassLoaderExtensions {
  public static void printHierarchy(final ClassLoader classLoader) {
    final ArrayList<ClassLoader> classLoaderHierarchy = new ArrayList<ClassLoader>();
    classLoaderHierarchy.add(classLoader);
    ClassLoader parentClassLoader = classLoader.getParent();
    while ((!Objects.equal(parentClassLoader, null))) {
      {
        classLoaderHierarchy.add(parentClassLoader);
        parentClassLoader = parentClassLoader.getParent();
      }
    }
    ListExtensions.<ClassLoader>reverse(classLoaderHierarchy);
    final Consumer<ClassLoader> _function = new Consumer<ClassLoader>() {
      @Override
      public void accept(final ClassLoader it) {
        ClassLoaderExtensions.print(it);
      }
    };
    classLoaderHierarchy.forEach(_function);
  }
  
  public static void print(final ClassLoader classLoader) {
    String classLoaderAsString = null;
    if ((classLoader instanceof ProjectClassLoader)) {
      classLoaderAsString = ((ProjectClassLoader)classLoader).toString();
    } else {
      if ((classLoader instanceof URLClassLoader)) {
        String _name = ((URLClassLoader)classLoader).getClass().getName();
        String _plus = (_name + " [urls=");
        String _string = Arrays.toString(((URLClassLoader)classLoader).getURLs());
        String _plus_1 = (_plus + _string);
        String _plus_2 = (_plus_1 + "]");
        classLoaderAsString = _plus_2;
      } else {
        classLoaderAsString = classLoader.toString();
      }
    }
    InputOutput.<String>println(classLoaderAsString);
  }
}
