/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.jdt.loaders;

import com.google.common.base.Objects;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.sphinx.jdt.loaders.DelegatingCompositeBundleClassLoader;
import org.eclipse.sphinx.jdt.util.JavaExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.osgi.framework.Bundle;

public class ProjectClassLoader
extends URLClassLoader {
    private IJavaProject javaProject;

    protected static URL[] getJavaOutputURLs(IJavaProject javaProject) {
        try {
            URL[] _xblockexpression = null;
            Assert.isNotNull((Object)javaProject);
            Assert.isLegal((javaProject.exists() && javaProject.isOpen() ? 1 : 0) != 0);
            IPath _location = JavaExtensions.getLocation(javaProject.getOutputLocation());
            File _file = null;
            if (_location != null) {
                _file = _location.toFile();
            }
            URI _uRI = null;
            if (_file != null) {
                _uRI = _file.toURI();
            }
            URL _uRL = null;
            if (_uRI != null) {
                _uRL = _uRI.toURL();
            }
            URL outputURL = _uRL;
            URL[] _xifexpression = null;
            boolean _notEquals = !Objects.equal((Object)outputURL, null);
            _xifexpression = _notEquals ? new URL[]{outputURL} : new URL[]{};
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected static ClassLoader hookupDependencyClassLoaders(IJavaProject javaProject, ClassLoader parent) {
        try {
            boolean _isEmpty_1;
            boolean _not_1;
            boolean _not;
            ClassLoader _xblockexpression = null;
            Assert.isNotNull((Object)javaProject);
            Assert.isLegal((javaProject.exists() && javaProject.isOpen() ? 1 : 0) != 0);
            ClassLoader lastClassLoader = parent;
            IClasspathEntry[] entries = javaProject.getResolvedClasspath(true);
            Functions.Function1<IClasspathEntry, Boolean> _function = new Functions.Function1<IClasspathEntry, Boolean>(){

                public Boolean apply(IClasspathEntry it) {
                    int _entryKind = it.getEntryKind();
                    return _entryKind == 2;
                }
            };
            Functions.Function1<IClasspathEntry, String> _function_1 = new Functions.Function1<IClasspathEntry, String>(){

                public String apply(IClasspathEntry it) {
                    return it.getPath().segment(0);
                }
            };
            Iterable requiredProjectNames = IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)entries)), (Functions.Function1)_function), (Functions.Function1)_function_1);
            for (String requiredProjectName : requiredProjectNames) {
                IJavaProject _javaProject = JavaExtensions.getJavaProject(requiredProjectName);
                ProjectClassLoader _projectClassLoader = new ProjectClassLoader(_javaProject, lastClassLoader);
                lastClassLoader = _projectClassLoader;
            }
            Functions.Function1<IClasspathEntry, Boolean> _function_2 = new Functions.Function1<IClasspathEntry, Boolean>(){

                public Boolean apply(IClasspathEntry it) {
                    int _entryKind = it.getEntryKind();
                    return _entryKind == 1;
                }
            };
            Functions.Function1<IClasspathEntry, File> _function_3 = new Functions.Function1<IClasspathEntry, File>(){

                public File apply(IClasspathEntry it) {
                    return JavaExtensions.getFile(it);
                }
            };
            Functions.Function1<File, Boolean> _function_4 = new Functions.Function1<File, Boolean>(){

                public Boolean apply(File it) {
                    return it.exists();
                }
            };
            Functions.Function1<File, URL> _function_5 = new Functions.Function1<File, URL>(){

                public URL apply(File it) {
                    try {
                        return it.toURI().toURL();
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            };
            Iterable libraryURLs = IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)entries)), (Functions.Function1)_function_2), (Functions.Function1)_function_3), (Functions.Function1)_function_4), (Functions.Function1)_function_5);
            ArrayList javaLibraryURLs = CollectionLiterals.newArrayList();
            ArrayList requiredBundles = CollectionLiterals.newArrayList();
            for (URL libraryURL : libraryURLs) {
                boolean _notEquals;
                Bundle requiredBundle = JavaExtensions.getBundle(libraryURL);
                boolean bl = _notEquals = !Objects.equal((Object)requiredBundle, null);
                if (_notEquals) {
                    requiredBundles.add(requiredBundle);
                    continue;
                }
                javaLibraryURLs.add(libraryURL);
            }
            boolean _isEmpty = requiredBundles.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                DelegatingCompositeBundleClassLoader _delegatingCompositeBundleClassLoader = new DelegatingCompositeBundleClassLoader(lastClassLoader, requiredBundles);
                lastClassLoader = _delegatingCompositeBundleClassLoader;
            }
            boolean bl2 = _not_1 = !(_isEmpty_1 = javaLibraryURLs.isEmpty());
            if (_not_1) {
                URLClassLoader _uRLClassLoader = new URLClassLoader((URL[])Conversions.unwrapArray((Object)javaLibraryURLs, URL.class), lastClassLoader);
                lastClassLoader = _uRLClassLoader;
            }
            _xblockexpression = lastClassLoader;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public ProjectClassLoader(IJavaProject javaProject) {
        this(javaProject, Thread.currentThread().getContextClassLoader());
    }

    public ProjectClassLoader(IJavaProject javaProject, ClassLoader parent) {
        super(ProjectClassLoader.getJavaOutputURLs(javaProject), ProjectClassLoader.hookupDependencyClassLoaders(javaProject, parent));
        this.javaProject = javaProject;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            Class<?> _xblockexpression = null;
            IType type = this.javaProject.findType(name);
            if (!Objects.equal((Object)type, null) && !type.isBinary() && this.javaProject.getPath().isPrefixOf(type.getPath())) {
                return this.findClass(name);
            }
            _xblockexpression = super.loadClass(name, resolve);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public String toString() {
        String _name = this.getClass().getName();
        String _plus = String.valueOf(_name) + " [project=";
        String _name_1 = this.javaProject.getProject().getName();
        String _plus_1 = String.valueOf(_plus) + _name_1;
        return String.valueOf(_plus_1) + "]";
    }

    public IJavaProject getProject() {
        return this.javaProject;
    }
}

