/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.typehierarchy;

import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.ui.ModelElementSorter;
import org.eclipse.dltk.ui.viewsupport.SourcePositionSorter;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public abstract class AbstractHierarchyViewerSorter
extends ViewerSorter {
    private static final int OTHER = 1;
    private static final int CLASS = 2;
    private static final int ANONYM = 3;
    private ModelElementSorter fNormalSorter = new ModelElementSorter();
    private SourcePositionSorter fSourcePositonSorter = new SourcePositionSorter();

    protected abstract ITypeHierarchy getHierarchy(IType var1);

    public abstract boolean isSortByDefiningType();

    public abstract boolean isSortAlphabetically();

    protected int getTypeFlags(IType type) throws ModelException {
        return type.getFlags();
    }

    public int category(Object element) {
        if (element instanceof IType) {
            IType type = (IType)element;
            if (type.getElementName().length() == 0) {
                return 3;
            }
            try {
                this.getTypeFlags(type);
                return 2;
            }
            catch (ModelException modelException) {}
        }
        return 1;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int cat2;
        if (!this.isSortAlphabetically() && !this.isSortByDefiningType()) {
            return this.fSourcePositonSorter.compare(viewer, e1, e2);
        }
        int cat1 = this.category(e1);
        if (cat1 != (cat2 = this.category(e2))) {
            return cat1 - cat2;
        }
        if (cat1 == 1) {
            block14: {
                if (this.isSortByDefiningType()) {
                    IType def2;
                    block13: {
                        try {
                            IType def1 = e1 instanceof IMethod ? this.getDefiningType((IMethod)e1) : null;
                            IType iType = def2 = e2 instanceof IMethod ? this.getDefiningType((IMethod)e2) : null;
                            if (def1 == null) break block13;
                            if (def2 != null) {
                                if (!def2.equals(def1)) {
                                    return this.compareInHierarchy(def1, def2);
                                }
                                break block14;
                            }
                            return -1;
                        }
                        catch (ModelException modelException) {}
                    }
                    if (def2 != null) {
                        return 1;
                    }
                }
            }
            if (this.isSortAlphabetically()) {
                return this.fNormalSorter.compare(viewer, e1, e2);
            }
            return 0;
        }
        if (cat1 == 3) {
            return 0;
        }
        if (this.isSortAlphabetically()) {
            String name1 = ((IType)e1).getElementName();
            String name2 = ((IType)e2).getElementName();
            return this.getCollator().compare(name1, name2);
        }
        return 0;
    }

    private IType getDefiningType(IMethod method) throws ModelException {
        return null;
    }

    private int compareInHierarchy(IType def1, IType def2) {
        if (ScriptModelUtil.isSuperType((ITypeHierarchy)this.getHierarchy(def1), (IType)def2, (IType)def1)) {
            return 1;
        }
        if (ScriptModelUtil.isSuperType((ITypeHierarchy)this.getHierarchy(def2), (IType)def1, (IType)def2)) {
            return -1;
        }
        String name1 = def1.getElementName();
        String name2 = def2.getElementName();
        return this.getCollator().compare(name1, name2);
    }
}

