/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.tclchecker;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.tcl.internal.tclchecker.StaticTclCheckerMessageFilter;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerHelper;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerMarker;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerMessageFilter;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerProblem;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerProblemDescription;
import org.eclipse.jface.preference.IPreferenceStore;

public class TclChecker {
    private IPreferenceStore store;
    private TclCheckerMessageFilter filter;

    protected static IMarker reportErrorProblem(IResource resource, TclCheckerProblem problem, int start, int end) throws CoreException {
        return TclCheckerMarker.setMarker(resource, problem.getLineNumber(), start, end, problem.getDescription().getMessage(), 2, 1);
    }

    protected static IMarker reportWarningProblem(IResource resource, TclCheckerProblem problem, int start, int end) throws CoreException {
        return TclCheckerMarker.setMarker(resource, problem.getLineNumber(), start, end, problem.getDescription().getMessage(), 1, 1);
    }

    private static void parseProblems(IResource res, String code, String[] output, TclCheckerMessageFilter filter) throws CoreException {
        TclCheckerCodeModel model = new TclCheckerCodeModel(code);
        int i = 0;
        while (i < output.length) {
            TclCheckerProblem problem = TclCheckerHelper.parseProblem(output[i], filter);
            if (problem != null) {
                TclCheckerProblemDescription desc = problem.getDescription();
                int[] bounds = model.getBounds(problem.getLineNumber() - 1);
                if (TclCheckerProblemDescription.isError(desc.getCategory())) {
                    TclChecker.reportErrorProblem(res, problem, bounds[0], bounds[1]);
                } else if (TclCheckerProblemDescription.isWarning(desc.getCategory())) {
                    TclChecker.reportWarningProblem(res, problem, bounds[0], bounds[1]);
                }
            }
            ++i;
        }
    }

    private boolean processImpl(ISourceModule module) throws CoreException {
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(module.getPath());
        if (res == null) {
            return false;
        }
        String code = module.getSource();
        TclCheckerMarker.clearMarkers(res);
        try {
            String[] output = TclCheckerHelper.execTclChecker(code, this.store);
            TclChecker.parseProblems(res, code, output, this.filter);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.tcl.tclchecker", 0, "I/O problem with TclChecker", (Throwable)e));
        }
        return true;
    }

    public TclChecker(IPreferenceStore store) {
        if (store == null) {
            throw new NullPointerException("store cannot be null");
        }
        this.store = store;
        this.filter = new StaticTclCheckerMessageFilter();
    }

    public boolean canCheck() {
        return TclCheckerHelper.canExecuteTclChecker(this.store);
    }

    public void check(final List sourceModules, final String workName, boolean userJob) {
        if (!this.canCheck()) {
            throw new IllegalStateException("TclChecker cannot be executed");
        }
        Job job = new Job(workName){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected IStatus run(IProgressMonitor monitor) {
                block8: {
                    IStatus iStatus;
                    block7: {
                        try {
                            try {
                                monitor.beginTask(workName, sourceModules.size());
                                Iterator it = sourceModules.iterator();
                                while (it.hasNext()) {
                                    if (monitor.isCanceled()) {
                                        iStatus = Status.CANCEL_STATUS;
                                        Object var4_7 = null;
                                        break block7;
                                    }
                                    ISourceModule module = (ISourceModule)it.next();
                                    if (!module.exists()) continue;
                                    TclChecker.this.processImpl(module);
                                    monitor.worked(1);
                                }
                                break block8;
                            }
                            catch (CoreException e) {
                                IStatus iStatus2 = e.getStatus();
                                Object var4_8 = null;
                                monitor.done();
                                return iStatus2;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var4_9 = null;
                            monitor.done();
                            throw throwable;
                        }
                    }
                    monitor.done();
                    return iStatus;
                }
                Object var4_10 = null;
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.setUser(userJob);
        job.schedule();
    }

    private static class TclCheckerCodeModel {
        private String[] codeLines;
        private int[] codeLineLengths;

        public TclCheckerCodeModel(String code) {
            this.codeLines = code.split("\n");
            int count = this.codeLines.length;
            this.codeLineLengths = new int[count];
            int sum = 0;
            int i = 0;
            while (i < count) {
                this.codeLineLengths[i] = sum;
                sum += this.codeLines[i].length() + 1;
                ++i;
            }
        }

        public int[] getBounds(int lineNumber) {
            String codeLine = this.codeLines[lineNumber];
            String trimmedCodeLine = codeLine.trim();
            int start = this.codeLineLengths[lineNumber] + codeLine.indexOf(trimmedCodeLine);
            int end = start + trimmedCodeLine.length();
            return new int[]{start, end};
        }
    }
}

