/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching.debug;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.internal.launching.debug.DebuggingEngine;
import org.eclipse.dltk.internal.launching.debug.PriorityBasedDebuggingEngineSelector;
import org.eclipse.dltk.launching.IInterpreterRunnerFactory;
import org.eclipse.dltk.launching.debug.IDebuggingEngine;
import org.eclipse.dltk.launching.debug.IDebuggingEngineSelector;

public class DebuggingEngineManager {
    private static DebuggingEngineManager instance;
    private IDebuggingEngineSelector defaultSelector;
    private Map natureToEnginesMap;
    private Map natureToSelectorMap;
    private static final String DEBUGGING_ENGINE_EXT_POINT = "org.eclipse.dltk.launching.debuggingEngine";
    private static final String ID = "id";
    private static final String NATURE_ID = "natureId";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String PRIORITY = "priority";
    private static final String CLASS = "class";
    private IDebuggingEngine[] NO_ENGINES = new IDebuggingEngine[0];

    public static DebuggingEngineManager getInstance() {
        if (instance == null) {
            instance = new DebuggingEngineManager();
        }
        return instance;
    }

    private void addEngine(String natureId, IConfigurationElement element) {
        String id = element.getAttribute(ID);
        String name = element.getAttribute(NAME);
        String description = element.getAttribute(DESCRIPTION);
        int priority = Integer.parseInt(element.getAttribute(PRIORITY));
        try {
            Object object = element.createExecutableExtension(CLASS);
            if (object instanceof IInterpreterRunnerFactory) {
                IInterpreterRunnerFactory factory = (IInterpreterRunnerFactory)object;
                DebuggingEngine engine = new DebuggingEngine(id, natureId, name, description, priority, factory);
                List engines = (List)this.natureToEnginesMap.get(natureId);
                if (engines == null) {
                    this.natureToEnginesMap.put(natureId, new ArrayList());
                }
                ((List)this.natureToEnginesMap.get(natureId)).add(engine);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void addSelector(String natureId, IConfigurationElement element) {
        try {
            Object object = element.createExecutableExtension(CLASS);
            if (object instanceof IDebuggingEngineSelector) {
                this.natureToSelectorMap.put(natureId, object);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void loadExtenstionPoints() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension[] extensions = registry.getExtensionPoint(DEBUGGING_ENGINE_EXT_POINT).getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            IConfigurationElement main = elements[0];
            String natureId = main.getAttribute(NATURE_ID);
            IConfigurationElement[] innerElements = main.getChildren();
            int j = 0;
            while (j < innerElements.length) {
                IConfigurationElement innerElement = innerElements[j];
                String name = innerElement.getName();
                if (name.equals("engine")) {
                    this.addEngine(natureId, innerElement);
                } else if (name.equals("selector")) {
                    this.addSelector(natureId, innerElement);
                }
                ++j;
            }
            ++i;
        }
    }

    protected DebuggingEngineManager() {
        this.defaultSelector = new PriorityBasedDebuggingEngineSelector();
        this.natureToEnginesMap = new HashMap();
        this.natureToSelectorMap = new HashMap();
        this.loadExtenstionPoints();
    }

    public IDebuggingEngine[] getDebuggingEngines(String natureId) {
        List engines = (List)this.natureToEnginesMap.get(natureId);
        if (engines != null) {
            return engines.toArray(new IDebuggingEngine[engines.size()]);
        }
        return this.NO_ENGINES;
    }

    public IDebuggingEngine getDebuggingEngine(String natureId, String id) {
        Iterator it = ((List)this.natureToEnginesMap.get(natureId)).iterator();
        while (it.hasNext()) {
            IDebuggingEngine engine = (IDebuggingEngine)it.next();
            if (!engine.getId().equals(id)) continue;
            return engine;
        }
        return null;
    }

    public IDebuggingEngine getSelectedDebuggineEngine(String natureId) {
        IDebuggingEngine[] engines = this.getDebuggingEngines(natureId);
        IDebuggingEngine engine = null;
        if (engines.length > 0) {
            IDebuggingEngineSelector selector = (IDebuggingEngineSelector)this.natureToSelectorMap.get(natureId);
            if (selector != null) {
                engine = selector.select(engines);
                if (engine == null) {
                    engine = this.defaultSelector.select(engines);
                }
            } else {
                engine = this.defaultSelector.select(engines);
            }
        }
        return engine;
    }
}

