/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.javascript.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Comment;
import org.eclipse.dltk.javascript.ast.IASTVisitor;
import org.eclipse.dltk.javascript.ast.ISourceable;
import org.eclipse.dltk.javascript.ast.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Script
extends ModuleDeclaration
implements ISourceable {
    private final List<Comment> comments = new ArrayList<Comment>();

    public Script() {
        super(0);
    }

    @Override
    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() == 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.getStatements().size()) {
            Statement statement = (Statement)this.getStatements().get(i);
            buffer.append(statement.toSourceString(indentationString));
            ++i;
        }
        return buffer.toString();
    }

    @Override
    public boolean isBlock() {
        return true;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public void addComment(Comment comment) {
        this.comments.add(comment);
    }

    public void visitAll(IASTVisitor visitor) {
        int i = 0;
        while (i < this.getStatements().size()) {
            Statement statement = (Statement)this.getStatements().get(i);
            ASTVisitor.visit(statement, visitor);
            ++i;
        }
    }
}

