/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.rhino.dbgp;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;
import java.util.WeakHashMap;
import org.eclipse.dltk.rhino.dbgp.Base64Helper;
import org.eclipse.dltk.rhino.dbgp.BreakCommand;
import org.eclipse.dltk.rhino.dbgp.BreakPoint;
import org.eclipse.dltk.rhino.dbgp.ContextGetCommand;
import org.eclipse.dltk.rhino.dbgp.ContextNamesCommand;
import org.eclipse.dltk.rhino.dbgp.DBGPDebugFrame;
import org.eclipse.dltk.rhino.dbgp.DBGPStackManager;
import org.eclipse.dltk.rhino.dbgp.EvalCommand;
import org.eclipse.dltk.rhino.dbgp.FeatureGetCommand;
import org.eclipse.dltk.rhino.dbgp.FeatureSetCommand;
import org.eclipse.dltk.rhino.dbgp.GetBreakPointCommand;
import org.eclipse.dltk.rhino.dbgp.LazyInitScope;
import org.eclipse.dltk.rhino.dbgp.PropertyGetCommand;
import org.eclipse.dltk.rhino.dbgp.PropertySetCommand;
import org.eclipse.dltk.rhino.dbgp.RemoveBreakPointCommand;
import org.eclipse.dltk.rhino.dbgp.RunCommand;
import org.eclipse.dltk.rhino.dbgp.SetBreakPointCommand;
import org.eclipse.dltk.rhino.dbgp.StackDepthCommand;
import org.eclipse.dltk.rhino.dbgp.StackGetCommand;
import org.eclipse.dltk.rhino.dbgp.StdErrCommand;
import org.eclipse.dltk.rhino.dbgp.StdInCommand;
import org.eclipse.dltk.rhino.dbgp.StdOutCommand;
import org.eclipse.dltk.rhino.dbgp.StepIntoCommand;
import org.eclipse.dltk.rhino.dbgp.StepOutCommand;
import org.eclipse.dltk.rhino.dbgp.StepOverCommand;
import org.eclipse.dltk.rhino.dbgp.StopCommand;
import org.eclipse.dltk.rhino.dbgp.UpdateBreakPointCommand;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.UniqueTag;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;
import org.mozilla.javascript.debug.IDeguggerWithWatchPoints;
import org.mozilla.javascript.xml.XMLObject;

public class DBGPDebugger
extends Thread
implements Debugger,
Observer,
IDeguggerWithWatchPoints {
    private Socket socket;
    private OutputStream out;
    private HashMap strategies = new HashMap();
    HashMap properties = new HashMap();
    String runTransctionId;
    DBGPStackManager stackmanager;
    public boolean isInited;
    WeakHashMap cache = new WeakHashMap();

    private static void writeResponseLength(OutputStream out, int value) throws IOException {
        out.write(String.valueOf(value).getBytes());
    }

    void printResponse(String response) {
        try {
            byte[] bytes = response.getBytes("UTF-8");
            DBGPDebugger.writeResponseLength(this.out, bytes.length);
            this.out.write(0);
            this.out.write(bytes, 0, bytes.length);
            this.out.write(0);
            this.out.flush();
        }
        catch (IOException iOException) {
            try {
                this.socket.close();
            }
            catch (IOException iOException2) {}
        }
    }

    public void setContext(Context cx) {
        DBGPStackManager manager = DBGPStackManager.getManager(cx);
        manager.setDebugger(this);
        this.stackmanager = manager;
    }

    public DBGPDebugger(Socket socket, String file, String string, Context ct) throws IOException {
        this.socket = socket;
        this.stackmanager = DBGPStackManager.getManager(ct);
        this.stackmanager.suspend();
        this.out = new BufferedOutputStream(socket.getOutputStream(), 2048);
        this.stackmanager.setDebugger(this);
        String response = "<init appid=\"APPID\"\r\n      idekey=\"" + string + "\"\r\n" + "      session=\"" + string + "\"\r\n" + "      thread=\"THREAD_ID\"\r\n" + "      parent=\"PARENT_APPID\"\r\n" + "      language=\"javascript\"\r\n" + "      protocol_version=\"1.0\"\r\n" + "      fileuri=\"file://" + file + "\"\r\n" + "/>";
        this.printResponse(response);
        this.strategies.put("feature_get", new FeatureGetCommand(this));
        this.strategies.put("feature_set", new FeatureSetCommand(this));
        this.strategies.put("stdin", new StdInCommand(this));
        this.strategies.put("stdout", new StdOutCommand(this));
        this.strategies.put("stderr", new StdErrCommand(this));
        this.strategies.put("run", new RunCommand(this));
        this.strategies.put("context_names", new ContextNamesCommand(this));
        this.strategies.put("stop", new StopCommand(this));
        this.strategies.put("step_over", new StepOverCommand(this));
        this.strategies.put("step_into", new StepIntoCommand(this));
        this.strategies.put("step_out", new StepOutCommand(this));
        this.strategies.put("breakpoint_get", new GetBreakPointCommand(this));
        this.strategies.put("breakpoint_set", new SetBreakPointCommand(this));
        this.strategies.put("breakpoint_remove", new RemoveBreakPointCommand(this));
        this.strategies.put("breakpoint_update", new UpdateBreakPointCommand(this));
        this.strategies.put("context_get", new ContextGetCommand(this));
        this.strategies.put("property_set", new PropertySetCommand(this));
        this.strategies.put("eval", new EvalCommand(this));
        this.strategies.put("property_get", new PropertyGetCommand(this));
        this.strategies.put("break", new BreakCommand(this));
        this.strategies.put("stack_depth", new StackDepthCommand(this));
        this.strategies.put("stack_get", new StackGetCommand(this));
    }

    protected void printProperty(String id, String fullName, Object value, StringBuffer properties, int level, boolean addChilds) {
        String vlEncoded;
        boolean hasChilds = false;
        int numC = 0;
        String name_of_object_class = "";
        String data_type = this.getDataType(value);
        if (value instanceof Scriptable) {
            Scriptable prototype;
            HashSet<Object> duplicates;
            String nv;
            hasChilds = true;
            StringBuffer stringBuffer = new StringBuffer();
            Scriptable p = (Scriptable)value;
            value = stringBuffer;
            name_of_object_class = nv = p.getClassName();
            if (p instanceof NativeJavaObject) {
                String string;
                NativeJavaObject obj = (NativeJavaObject)p;
                Object unwrap = obj.unwrap();
                nv = unwrap instanceof Class ? ((Class)unwrap).getName() : (unwrap.getClass().isArray() ? "Array" : (unwrap instanceof String ? "JavaString \"" + unwrap.toString() + '\"' : (string = unwrap.toString())));
            } else if (p instanceof Wrapper) {
                Wrapper wrapper = (Wrapper)p;
                Object wrapped = wrapper.unwrap();
                if (wrapped == null) {
                    nv = "Undefined";
                } else if (!wrapped.getClass().isArray()) {
                    nv = wrapped.toString();
                }
            } else if (p instanceof XMLObject) {
                nv = ((XMLObject)p).toString();
                data_type = "XML";
            }
            stringBuffer.append(Base64Helper.encodeString(nv));
            if (addChilds) {
                duplicates = new HashSet<Object>();
                prototype = p;
                while (prototype != null) {
                    numC += this.createChilds(fullName, level, stringBuffer, prototype, duplicates);
                    prototype = prototype.getPrototype();
                }
            } else {
                duplicates = new HashSet();
                prototype = p;
                while (prototype != null) {
                    Object[] ids = null;
                    ids = prototype instanceof LazyInitScope ? ((LazyInitScope)prototype).getInitializedIds() : prototype.getIds();
                    int a = 0;
                    while (a < ids.length) {
                        if (duplicates.add(ids[a])) {
                            Object pvalue = null;
                            try {
                                pvalue = ids[a] instanceof Integer ? p.get(((Integer)ids[a]).intValue(), p) : p.get(ids[a].toString(), p);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            if (!(pvalue instanceof Function)) {
                                ++numC;
                            }
                        }
                        ++a;
                    }
                    prototype = prototype.getPrototype();
                }
            }
            vlEncoded = stringBuffer.toString();
        } else {
            vlEncoded = !(value instanceof Undefined) ? (value == UniqueTag.NOT_FOUND ? "" : Base64Helper.encodeString(value != null ? value.toString() : "null")) : Base64Helper.encodeString("Undefined");
            if (value != null) {
                name_of_object_class = value.getClass().getName();
            }
        }
        id = DBGPDebugger.escapeHTML(id);
        fullName = DBGPDebugger.escapeHTML(fullName);
        properties.append("<property\r\n    name=\"" + id + "\"\r\n" + "    fullname=\"" + fullName + "\"\r\n" + "    type=\"" + data_type + "\"\r\n" + "    classname=\"" + name_of_object_class + "\"\r\n" + "    constant=\"0\"\r\n" + "    children=\"" + (hasChilds ? 1 : 0) + "\"\r\n" + "    encoding=\"base64\"\r\n" + "    numchildren=\"" + numC + "\">\r\n" + vlEncoded + "</property>\r\n");
    }

    private static String escapeHTML(String content) {
        content = DBGPDebugger.replace(content, '&', "&amp;");
        content = DBGPDebugger.replace(content, '\"', "&quot;");
        content = DBGPDebugger.replace(content, '<', "&lt;");
        return DBGPDebugger.replace(content, '>', "&gt;");
    }

    private static String replace(String text, char c, String s) {
        int previous = 0;
        int current = text.indexOf(c, previous);
        if (current == -1) {
            return text;
        }
        StringBuffer buffer = new StringBuffer();
        while (current > -1) {
            buffer.append(text.substring(previous, current));
            buffer.append(s);
            previous = current + 1;
            current = text.indexOf(c, previous);
        }
        buffer.append(text.substring(previous));
        return buffer.toString();
    }

    private int createChilds(String fullName, int level, StringBuffer stringBuffer, Scriptable p, HashSet duplicates) {
        Object[] ids = null;
        ids = p instanceof LazyInitScope ? ((LazyInitScope)p).getInitializedIds() : (p instanceof ScriptableObject && !(p instanceof XMLObject) && !(p instanceof NativeArray) ? ((ScriptableObject)p).getAllIds() : p.getIds());
        int counter = 0;
        int a = 0;
        while (a < ids.length) {
            if (duplicates.add(ids[a])) {
                Object pvalue = null;
                try {
                    pvalue = ids[a] instanceof Integer ? p.get(((Integer)ids[a]).intValue(), p) : p.get(ids[a].toString(), p);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                if (!(pvalue instanceof Function)) {
                    ++counter;
                    if (ids[a] instanceof Integer) {
                        this.printProperty(ids[a].toString(), String.valueOf(fullName) + "[" + ids[a] + "]", pvalue, stringBuffer, level + 1, false);
                    } else {
                        this.printProperty(ids[a].toString(), String.valueOf(fullName) + "." + ids[a], pvalue, stringBuffer, level + 1, false);
                    }
                }
            }
            ++a;
        }
        return counter;
    }

    private String getDataType(Object value) {
        String data_type = "Object";
        if (value instanceof Function) {
            data_type = "function";
        } else if (value instanceof NativeJavaArray) {
            data_type = "javaarray";
        } else if (value instanceof NativeArray) {
            data_type = "array";
        } else if (value instanceof NativeJavaObject) {
            data_type = "javaobject";
        } else if (value instanceof NativeJavaClass) {
            data_type = "javaclass";
        } else if (value instanceof String) {
            data_type = "string";
        } else if (value instanceof Number) {
            data_type = "number";
        } else if (value instanceof Boolean) {
            data_type = "boolean";
        } else if (value instanceof Date) {
            data_type = "date";
        } else if (value instanceof Undefined || value == null) {
            data_type = "undefined";
        } else if (value instanceof Wrapper) {
            return this.getDataType(((Wrapper)value).unwrap());
        }
        return data_type;
    }

    public void run() {
        try {
            DataInputStream ds = new DataInputStream(this.socket.getInputStream());
            StringBuffer buf = new StringBuffer();
            Context.enter();
            while (ds.available() >= 0) {
                int c = ds.read();
                if (c < 0) break;
                if (c < 32) {
                    String s = buf.toString();
                    int indexOf = s.indexOf(32);
                    if (indexOf != -1) {
                        String commandId = buf.substring(0, indexOf);
                        Command object = (Command)this.strategies.get(commandId);
                        if (object == null) {
                            System.err.println(commandId);
                            continue;
                        }
                        HashMap<String, String> options = new HashMap<String, String>();
                        String result = buf.substring(indexOf + 1);
                        String[] split = result.split(" ");
                        try {
                            int a = 0;
                            while (a < split.length) {
                                options.put(split[a], split[++a]);
                                ++a;
                            }
                        }
                        catch (Exception exception) {}
                        object.parseAndExecute(result, options);
                    }
                    buf = new StringBuffer();
                    continue;
                }
                buf.append((char)c);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public DebugFrame getFrame(Context cx, DebuggableScript fnOrScript) {
        return new DBGPDebugFrame(cx, fnOrScript, this);
    }

    public void handleCompilationDone(Context cx, DebuggableScript fnOrScript, String source) {
    }

    public void update(Observable arg0, Object arg1) {
        if (this.runTransctionId != null) {
            this.printResponse("<response command=\"run\"\r\nstatus=\"break\" reason=\"ok\" transaction_id=\"" + this.runTransctionId + "\">\r\n" + "</response>\r\n");
        }
    }

    public void notifyEnd() {
        this.printResponse("<response command=\"run\"\r\nstatus=\"stopped\" reason=\"ok\" transaction_id=\"" + this.runTransctionId + "\">\r\n" + "</response>\r\n");
        System.exit(0);
    }

    public void access(String property, ScriptableObject object) {
        ArrayList list = (ArrayList)this.stackmanager.getManager().getWatchPoints(property);
        if (list != null) {
            int size = list.size();
            int a = 0;
            while (a < size) {
                BreakPoint watchPoint = (BreakPoint)list.get(a);
                if (watchPoint != null && watchPoint.enabled && watchPoint.isAccess) {
                    String wkey = String.valueOf(watchPoint.file) + watchPoint.line;
                    String s = (String)this.cache.get(object);
                    if (s != null && s.equals(wkey)) {
                        this.stackmanager.getObserver().update(null, this);
                        this.stackmanager.waitForNotify();
                    }
                }
                ++a;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modification(String property, ScriptableObject object) {
        ArrayList list = (ArrayList)this.stackmanager.getManager().getWatchPoints(property);
        if (list != null && this.stackmanager.getStackDepth() > 0) {
            int size = list.size();
            int a = 0;
            while (a < size) {
                BreakPoint watchPoint = (BreakPoint)list.get(a);
                if (watchPoint != null && watchPoint.enabled) {
                    Object object2;
                    String wkey;
                    String sn = this.stackmanager.getStackFrame(0).getSourceName();
                    int ln = this.stackmanager.getStackFrame(0).getLineNumber();
                    String key = String.valueOf(sn) + ln;
                    if (key.equals(wkey = String.valueOf(watchPoint.file) + watchPoint.line)) {
                        this.cache.put(object, wkey);
                    }
                    if (watchPoint.isModification && (object2 = this.cache.get(object)) != null && object2.equals(wkey)) {
                        this.stackmanager.getObserver().update(null, this);
                        DBGPStackManager dBGPStackManager = this.stackmanager;
                        synchronized (dBGPStackManager) {
                            try {
                                this.stackmanager.wait();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                ++a;
            }
        }
    }

    public void setProperty(String name, String value) {
    }

    public void setSuspendOnExit(boolean parseBoolean) {
        this.stackmanager.setSuspendOnExit(parseBoolean);
    }

    public void setSuspendOnEntry(boolean parseBoolean) {
        this.stackmanager.setSuspendOnEntry(parseBoolean);
    }

    static abstract class Command {
        Command() {
        }

        abstract void parseAndExecute(String var1, HashMap var2);
    }
}

