/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.parser;

import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.Token;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.dltk.javascript.ast.Keywords;
import org.eclipse.dltk.javascript.parser.JavaScriptToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptTokenFilter {
    private int skipBlanks(List<Token> source, int start) {
        int i = start;
        while (i < source.size()) {
            switch (source.get(i).getType()) {
                case 159: 
                case 165: 
                case 166: 
                case 167: {
                    break;
                }
                default: {
                    return i;
                }
            }
            ++i;
        }
        return start;
    }

    private int skipXmlFragment(List<Token> source, int start) {
        ISourceRange fragment;
        int p = this.skipBlanks(source, start);
        if (p < source.size() && (fragment = this.getXmlFragmentRange(source, p)) != null) {
            return p + fragment.getLength();
        }
        return start;
    }

    private int skipText(List<Token> source, int start, int closeToken) {
        int i = start;
        while (i < source.size()) {
            if (source.get(i).getType() == closeToken) {
                return i + 1;
            }
            ++i;
        }
        return start;
    }

    private boolean isMinus(Token token) {
        return token.getType() == 88 || token.getType() == 143;
    }

    private boolean isXmlCommentOpenTag(List<Token> source, int start) {
        if (start + 3 > source.size() - 1) {
            return false;
        }
        if (source.get(start).getType() != 79) {
            return false;
        }
        if (source.get(start + 1).getType() != 99) {
            return false;
        }
        if (!this.isMinus(source.get(start + 2))) {
            return false;
        }
        return this.isMinus(source.get(start + 3));
    }

    private boolean isXmlCommentCloseTag(List<Token> source, int start) {
        if (start + 2 > source.size() - 1) {
            return false;
        }
        if (!this.isMinus(source.get(start))) {
            return false;
        }
        if (!this.isMinus(source.get(start + 1))) {
            return false;
        }
        return source.get(start + 2).getType() == 80;
    }

    private int skipText(List<Token> source, int start) {
        int i = start;
        while (i < source.size()) {
            switch (source.get(i).getType()) {
                case 79: 
                case 118: {
                    return i;
                }
                case 80: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: {
                    return i;
                }
                case 75: {
                    if (i >= source.size() - 2 || source.get(i + 1).getType() != 75 || source.get(i + 2).getType() != 80) break;
                    return i + 2;
                }
            }
            ++i;
        }
        return start;
    }

    private ISourceRange getXmlSimpleFragmentRange(List<Token> source, int start, int openToken, int closeToken) {
        if (source.get(start).getType() != openToken) {
            return null;
        }
        int i = start + 1;
        while (i < source.size()) {
            if (source.get(i).getType() == closeToken) {
                return new SourceRange(start, i - start + 1);
            }
            ++i;
        }
        return null;
    }

    private ISourceRange getXmlCDATARange(List<Token> source, int start) {
        if (source.get(start).getType() != 122 || start + 5 >= source.size()) {
            return null;
        }
        if (source.get(start + 1).getType() != 36) {
            return null;
        }
        if (source.get(start + 2).getType() != 74) {
            return null;
        }
        int i = start + 3;
        while (i < source.size() - 2) {
            if (source.get(i).getType() == 75 && source.get(i + 1).getType() == 75 && source.get(i + 2).getType() == 80) {
                return new SourceRange(start, i + 2 - start + 1);
            }
            ++i;
        }
        return null;
    }

    private boolean isXmlFragmentTagItem(Token tk) {
        if (Keywords.isKeyword(tk.getText())) {
            return true;
        }
        switch (tk.getType()) {
            case 40: 
            case 105: 
            case 159: 
            case 165: 
            case 168: 
            case 169: 
            case 180: 
            case 181: {
                return true;
            }
        }
        return false;
    }

    private ISourceRange getXmlContainerFragmentRange(List<Token> source, int start) {
        if (source.get(start).getType() != 79) {
            return null;
        }
        int i = start + 1;
        while (i < source.size()) {
            Token tk = source.get(i);
            if (!this.isXmlFragmentTagItem(tk)) {
                switch (tk.getType()) {
                    case 121: {
                        return new SourceRange(start, i - start + 1);
                    }
                    case 80: {
                        int p = i + 1;
                        while (true) {
                            int skipped = p;
                            skipped = this.skipXmlFragment(source, skipped);
                            if (p == (skipped = this.skipText(source, skipped))) break;
                            p = skipped;
                        }
                        p = this.skipBlanks(source, p);
                        if (source.get(p).getType() == 120) {
                            p = this.skipText(source, p, 80);
                        }
                        return new SourceRange(start, p - start);
                    }
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    private ISourceRange getXmlFragmentRange(List<Token> source, int start) {
        Token tk = source.get(start);
        switch (tk.getType()) {
            case 123: {
                return this.getXmlSimpleFragmentRange(source, start, 123, 124);
            }
            case 118: {
                return this.getXmlSimpleFragmentRange(source, start, 118, 119);
            }
            case 122: {
                return this.getXmlCDATARange(source, start);
            }
            case 79: {
                return this.getXmlContainerFragmentRange(source, start);
            }
        }
        return null;
    }

    private int getXmlStringRange(List<Token> source, int start) {
        int i = start;
        int stop = -1;
        while (i < source.size()) {
            ISourceRange xmlFragment = this.getXmlFragmentRange(source, i);
            if (xmlFragment == null) break;
            stop = xmlFragment.getOffset() + xmlFragment.getLength();
            stop = i = this.skipBlanks(source, stop);
        }
        return stop;
    }

    private boolean isNotXmlStart(List<Token> source, int start) {
        int i = start;
        while (i >= 0) {
            switch (source.get(i).getType()) {
                case 159: 
                case 165: 
                case 166: 
                case 167: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 25: 
                case 73: 
                case 75: 
                case 168: 
                case 169: 
                case 181: 
                case 182: 
                case 183: {
                    return true;
                }
                default: {
                    return false;
                }
            }
            --i;
        }
        return false;
    }

    public List<Token> filter(List<Token> source) {
        ArrayList<Token> tokens = new ArrayList<Token>(source.size());
        int i = 0;
        while (i < source.size()) {
            Token tk = source.get(i);
            switch (tk.getType()) {
                case 79: 
                case 118: 
                case 122: 
                case 123: {
                    int xmlEnd;
                    boolean skip = false;
                    if (tk.getType() == 79) {
                        skip = this.isNotXmlStart(source, tk.getTokenIndex() - 1);
                    }
                    if (!skip && (xmlEnd = this.getXmlStringRange(source, i)) >= 0) {
                        JavaScriptToken xmlToken = new JavaScriptToken();
                        xmlToken.setLine(tk.getLine());
                        xmlToken.setCharPositionInLine(tk.getCharPositionInLine());
                        xmlToken.setChannel(0);
                        xmlToken.setType(193);
                        xmlToken.setText(this.toString(source, i, xmlEnd - 1));
                        tokens.add(xmlToken);
                        i = xmlEnd - 1;
                        break;
                    }
                }
                default: {
                    JavaScriptToken newToken = new JavaScriptToken(source.get(i));
                    tokens.add(newToken);
                }
            }
            ++i;
        }
        return tokens;
    }

    private String toString(List<Token> tokens, int start, int stop) {
        if (start < 0 || stop < 0) {
            return null;
        }
        if (stop >= tokens.size()) {
            stop = tokens.size() - 1;
        }
        StringBuffer buf = new StringBuffer();
        int i = start;
        while (i <= stop) {
            Token t = tokens.get(i);
            buf.append(t.getText());
            ++i;
        }
        return buf.toString();
    }
}

