/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui;

import java.util.List;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.text.hover.AbstractScriptEditorTextHover;
import org.eclipse.dltk.tcl.ast.TclModule;
import org.eclipse.dltk.tcl.ast.TclModuleDeclaration;
import org.eclipse.dltk.tcl.core.TclPackagesManager;
import org.eclipse.dltk.tcl.core.packages.TclModuleInfo;
import org.eclipse.dltk.tcl.core.packages.TclSourceEntry;
import org.eclipse.dltk.tcl.core.packages.UserCorrection;
import org.eclipse.dltk.tcl.indexing.PackageSourceCollector;
import org.eclipse.dltk.tcl.parser.TclParser;
import org.eclipse.dltk.tcl.parser.definitions.DefinitionManager;
import org.eclipse.dltk.tcl.parser.definitions.IScopeProcessor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public class PackagesSourcesHover
extends AbstractScriptEditorTextHover {
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        TclModule module;
        ISourceModule sourceModule;
        block19: {
            String nature = null;
            ISourceModule inputModelElement = EditorUtility.getEditorInputModelElement((IEditorPart)this.getEditor(), (boolean)false);
            if (inputModelElement == null) {
                return null;
            }
            IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)inputModelElement);
            if (toolkit == null) {
                return null;
            }
            nature = toolkit.getNatureId();
            if (nature == null || !"org.eclipse.dltk.tcl.core.nature".equals(nature)) {
                return null;
            }
            sourceModule = (ISourceModule)inputModelElement.getAncestor(5);
            ModuleDeclaration declaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
            module = null;
            if (declaration instanceof TclModuleDeclaration) {
                module = ((TclModuleDeclaration)declaration).getTclModule();
            } else {
                TclParser parser = new TclParser();
                try {
                    module = parser.parseModule(sourceModule.getSource(), null, (IScopeProcessor)DefinitionManager.getInstance().getCoreProcessor());
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block19;
                    e.printStackTrace();
                }
            }
        }
        if (module != null) {
            PackageSourceCollector collector = new PackageSourceCollector();
            collector.process((List)module.getStatements(), sourceModule);
            TclModuleInfo info = collector.getCurrentModuleInfo();
            EList sourced = info.getSourced();
            EList required = info.getRequired();
            List projectModules = TclPackagesManager.getProjectModules((String)sourceModule.getScriptProject().getElementName());
            String handle = sourceModule.getHandleIdentifier();
            EList sourceCorrections = null;
            EList packageCorrections = null;
            for (TclModuleInfo tclModuleInfo : projectModules) {
                if (!tclModuleInfo.getHandle().equals(handle)) continue;
                sourceCorrections = tclModuleInfo.getSourceCorrections();
                packageCorrections = tclModuleInfo.getPackageCorrections();
                break;
            }
            if (sourceCorrections != null) {
                for (TclSourceEntry tclSourceEntry : sourced) {
                    if (tclSourceEntry.getStart() > hoverRegion.getOffset() || hoverRegion.getOffset() > tclSourceEntry.getEnd()) continue;
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("Source information:");
                    boolean added = false;
                    for (UserCorrection userCorrection : sourceCorrections) {
                        if (!userCorrection.getOriginalValue().equals(tclSourceEntry.getValue())) continue;
                        EList userValue = userCorrection.getUserValue();
                        buffer.append("<ul>");
                        for (String value : userValue) {
                            buffer.append("<li>").append(value).append("</li>");
                            added = true;
                        }
                        buffer.append("</ul>");
                    }
                    if (added) {
                        return buffer.toString();
                    }
                    return "";
                }
            }
            if (packageCorrections != null) {
                for (TclSourceEntry tclSourceEntry : required) {
                    if (tclSourceEntry.getStart() > hoverRegion.getOffset() || hoverRegion.getOffset() > tclSourceEntry.getEnd()) continue;
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("Require information:");
                    boolean added = false;
                    for (UserCorrection userCorrection : packageCorrections) {
                        if (!userCorrection.getOriginalValue().equals(tclSourceEntry.getValue())) continue;
                        EList userValue = userCorrection.getUserValue();
                        buffer.append("<ul>");
                        for (String value : userValue) {
                            buffer.append("<li>").append(value).append("</li>");
                            added = true;
                        }
                        buffer.append("</ul>");
                    }
                    if (added) {
                        return buffer.toString();
                    }
                    return "";
                }
            }
        }
        return "";
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new AbstractReusableInformationControlCreator(){

            protected IInformationControl doCreateInformationControl(Shell parent) {
                DefaultInformationControl ctrl = new DefaultInformationControl(parent, false);
                return ctrl;
            }
        };
    }
}

