/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.parser;

import org.eclipse.dltk.compiler.problem.DefaultProblemIdentifier;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.compiler.problem.IProblemIdentifierExtension2;
import org.eclipse.dltk.compiler.problem.ProblemSeverity;
import org.eclipse.dltk.core.PreferencesLookupDelegate;
import org.eclipse.dltk.javascript.parser.ISeverityReporter;

public class JavaScriptParserSeverityReporter
implements ISeverityReporter {
    public ProblemSeverity getSeverity(IProblemIdentifier problemId, ProblemSeverity defaultSeverity) {
        String severity;
        IProblemIdentifier prime;
        if (problemId instanceof IProblemIdentifierExtension2 && (prime = ((IProblemIdentifierExtension2)problemId).getPrimeIdentifier()) != null) {
            problemId = prime;
        }
        if (defaultSeverity == null) {
            defaultSeverity = ProblemSeverity.WARNING;
        }
        if ((severity = new PreferencesLookupDelegate(null).getString(problemId.contributor(), DefaultProblemIdentifier.encode((IProblemIdentifier)problemId))) != null && severity.length() != 0) {
            if (ProblemSeverity.ERROR.name().equals(severity)) {
                return ProblemSeverity.ERROR;
            }
            if (ProblemSeverity.WARNING.name().equals(severity)) {
                return ProblemSeverity.WARNING;
            }
            if (ProblemSeverity.INFO.name().equals(severity)) {
                return ProblemSeverity.INFO;
            }
            if (ProblemSeverity.IGNORE.name().equals(severity)) {
                return null;
            }
        }
        return defaultSeverity;
    }
}

