/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.ast;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;

public class RubyBlock
extends ASTNode {
    private Map vars = new HashMap();
    private ASTNode asterixParameter = null;
    private ASTNode body;

    public RubyBlock(int start, int end, ASTNode body) {
        super(start, end);
        this.body = body;
    }

    public ASTNode getAsterixParameter() {
        return this.asterixParameter;
    }

    public void setAsterixParameter(ASTNode asterixParameter) {
        this.asterixParameter = asterixParameter;
    }

    public RubyBlock(int start, int end) {
        super(start, end);
    }

    public Set getVars() {
        return this.vars.keySet();
    }

    public void addVar(ASTNode var) {
        this.addVar(var, null);
    }

    public void addVar(ASTNode var, ASTNode defaultValue) {
        this.vars.put(var, defaultValue);
    }

    public ASTNode getBody() {
        return this.body;
    }

    public void setBody(ASTNode body) {
        this.body = body;
    }

    public int getKind() {
        return 0;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            for (ASTNode var : this.vars.keySet()) {
                if (var == null) continue;
                var.traverse(visitor);
            }
            for (ASTNode var : this.vars.values()) {
                if (var == null) continue;
                var.traverse(visitor);
            }
            if (this.body != null) {
                this.body.traverse(visitor);
            }
            if (this.asterixParameter != null) {
                this.asterixParameter.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }
}

