/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.ui.manpages.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.tcl.internal.ui.TclUI;
import org.eclipse.dltk.tcl.ui.manpages.Documentation;
import org.eclipse.dltk.tcl.ui.manpages.ManPageResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManPageResourceImpl
extends XMIResourceImpl
implements ManPageResource {
    public static final String ENCODING = "UTF-8";

    public <T extends EObject> List<T> select(Class<T> clazz) {
        return new ContentList<T>(clazz);
    }

    @Override
    public Documentation findDefault() {
        for (Documentation documentation : this.getDocumentations()) {
            if (!documentation.isDefault()) continue;
            return documentation;
        }
        return null;
    }

    @Override
    public Documentation findByName(String name) {
        if (name != null) {
            for (Documentation documentation : this.getDocumentations()) {
                if (!name.equals(documentation.getName())) continue;
                return documentation;
            }
        }
        return null;
    }

    @Override
    public Documentation findById(String id) {
        if (id != null) {
            for (Documentation documentation : this.getDocumentations()) {
                if (!id.equals(documentation.getId())) continue;
                return documentation;
            }
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.getContents().isEmpty();
    }

    public void verify() {
        for (Documentation documentation : this.getDocumentations()) {
            String id = documentation.getId();
            if (id != null && id.length() != 0) continue;
            documentation.setId(EcoreUtil.generateUUID());
        }
        this.checkDefault();
    }

    @Override
    public List<Documentation> getDocumentations() {
        return this.select(Documentation.class);
    }

    @Override
    public void checkDefault() {
        List<Documentation> documentations = this.getDocumentations();
        ArrayList<Documentation> defaults = new ArrayList<Documentation>();
        for (Documentation doc : documentations) {
            if (!doc.isDefault()) continue;
            defaults.add(doc);
        }
        if (defaults.size() == 1) {
            return;
        }
        if (documentations.isEmpty()) {
            return;
        }
        if (defaults.isEmpty()) {
            documentations.get(0).setDefault(true);
        } else {
            int i = 1;
            while (i < defaults.size()) {
                ((Documentation)defaults.get(i)).setDefault(false);
                ++i;
            }
        }
    }

    public void save(Map<?, ?> options) throws IOException {
        StringWriter writer = new StringWriter();
        HashMap<Object, Object> saveOptions = new HashMap<Object, Object>();
        if (options != null) {
            saveOptions.putAll(options);
        }
        saveOptions.put("FORMATTED", Boolean.FALSE);
        saveOptions.put("ENCODING", ENCODING);
        this.save((OutputStream)new URIConverter.WriteableOutputStream((Writer)writer, ENCODING), saveOptions);
        TclUI.getDefault().getPreferenceStore().setValue("doc_man_pages_locations", writer.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ContentList<E extends EObject>
    extends AbstractList<E> {
        private final Class<E> clazz;

        public ContentList(Class<E> clazz) {
            this.clazz = clazz;
        }

        @Override
        public E get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException();
            }
            for (EObject object : ManPageResourceImpl.this.getContents()) {
                if (!this.clazz.isInstance(object)) continue;
                if (index == 0) {
                    return (E)object;
                }
                --index;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int size() {
            int size = 0;
            for (EObject object : ManPageResourceImpl.this.getContents()) {
                if (!this.clazz.isInstance(object)) continue;
                ++size;
            }
            return size;
        }

        @Override
        public boolean add(E e) {
            ManPageResourceImpl.this.getContents().add(e);
            return true;
        }
    }
}

