/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editparts;

import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.MouseWheelHelper;
import org.eclipse.gef.editparts.ViewportHelper;
import org.eclipse.swt.widgets.Event;

public class ViewportMouseWheelHelper
extends ViewportHelper
implements MouseWheelHelper {
    private static final int LINE_HEIGHT = 12;
    private int lineHeight;
    private int pageHeight;

    public ViewportMouseWheelHelper(GraphicalEditPart part) {
        this(part, -1, -1);
    }

    public ViewportMouseWheelHelper(GraphicalEditPart part, int lineHeight, int pageHeight) {
        super(part);
        this.setLineHeight(lineHeight);
        this.setPageHeight(pageHeight);
    }

    @Override
    public void handleMouseWheelScrolled(Event event) {
        Viewport viewport = this.findViewport(this.owner);
        if (viewport == null || !viewport.isShowing()) {
            return;
        }
        RangeModel rModel = viewport.getVerticalRangeModel();
        if (rModel.getExtent() < rModel.getMaximum() - rModel.getMinimum()) {
            int currentPos = rModel.getValue();
            int scrollHeight = this.lineHeight;
            if (event.detail == 2) {
                scrollHeight = this.pageHeight > this.lineHeight ? this.pageHeight : Math.max(this.lineHeight, viewport.getClientArea((Rectangle)Rectangle.SINGLETON).height - 26);
            }
            viewport.setVerticalLocation(currentPos - (scrollHeight *= event.count));
            if (rModel.getValue() != currentPos) {
                event.doit = false;
            }
        }
    }

    public void setLineHeight(int height) {
        this.lineHeight = height > 0 ? height : 12;
    }

    public void setPageHeight(int height) {
        this.pageHeight = height;
    }
}

