/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.utils;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.lemminx.services.CompletionResponse;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemDefaults;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class CompletionItemDefaultsUtils {
    private static final String ITEM_DEFAULTS_EDIT_RANGE = "editRange";
    private static final String ITEM_DEFAULTS_INSERT_TEXT_FORMAT = "insertTextFormat";

    public static void process(CompletionResponse completionResponse, SharedSettings sharedSettings) {
        CompletionItemDefaults itemDefaults = new CompletionItemDefaults();
        List<CompletionItem> completionList = completionResponse.getItems();
        if (sharedSettings.getCompletionSettings().isCompletionListItemDefaultsSupport(ITEM_DEFAULTS_EDIT_RANGE)) {
            CompletionItemDefaultsUtils.setToMostCommonEditRange(completionList, itemDefaults);
            completionResponse.setItemDefaults(itemDefaults);
        }
        if (sharedSettings.getCompletionSettings().isCompletionListItemDefaultsSupport(ITEM_DEFAULTS_INSERT_TEXT_FORMAT)) {
            CompletionItemDefaultsUtils.setToMostCommonInsertTextFormat(completionList, itemDefaults);
            completionResponse.setItemDefaults(itemDefaults);
        }
    }

    private static void setToMostCommonEditRange(List<CompletionItem> completionList, CompletionItemDefaults itemDefaults) {
        Map<Range, List<CompletionItem>> itemsByRange = completionList.stream().filter(item -> item.getTextEdit() != null && item.getTextEdit().isLeft()).collect(Collectors.groupingBy(item -> item.getTextEdit().getLeft().getRange()));
        int maxCount = 0;
        Range mostCommonRange = null;
        for (Map.Entry<Range, List<CompletionItem>> entry : itemsByRange.entrySet()) {
            int currentSize = entry.getValue().size();
            if (currentSize <= maxCount) continue;
            maxCount = currentSize;
            mostCommonRange = entry.getKey();
        }
        if (mostCommonRange == null) {
            return;
        }
        itemsByRange.get(mostCommonRange).forEach(item -> {
            item.setTextEditText(item.getTextEdit().getLeft().getNewText());
            item.setTextEdit(null);
        });
        itemDefaults.setEditRange(Either.forLeft(mostCommonRange));
        completionList = itemsByRange.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static void setToMostCommonInsertTextFormat(List<CompletionItem> completionList, CompletionItemDefaults itemDefaults) {
        Map<InsertTextFormat, List<CompletionItem>> itemsByInsertTextFormat = completionList.stream().filter(item -> item.getInsertTextFormat() != null).collect(Collectors.groupingBy(item -> item.getInsertTextFormat()));
        int maxCount = 0;
        InsertTextFormat mostCommonInsertTextFormat = null;
        for (Map.Entry<InsertTextFormat, List<CompletionItem>> entry : itemsByInsertTextFormat.entrySet()) {
            int currentSize = entry.getValue().size();
            if (currentSize <= maxCount) continue;
            maxCount = currentSize;
            mostCommonInsertTextFormat = entry.getKey();
        }
        if (mostCommonInsertTextFormat == null) {
            return;
        }
        itemsByInsertTextFormat.get((Object)mostCommonInsertTextFormat).forEach(item -> item.setInsertTextFormat(null));
        itemDefaults.setInsertTextFormat(mostCommonInsertTextFormat);
        completionList = itemsByInsertTextFormat.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }
}

