/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.core.spi;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.mylyn.reviews.core.spi.ReviewsClient;
import org.eclipse.mylyn.reviews.core.spi.remote.RemoteFactoryProviderConfigurer;
import org.eclipse.mylyn.reviews.internal.core.TaskReviewsMappingsStore;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public abstract class ReviewsConnector
extends AbstractRepositoryConnector {
    Map<TaskRepository, ReviewsClient> clientForRepository = new HashMap<TaskRepository, ReviewsClient>();
    private RemoteFactoryProviderConfigurer factoryProviderConfigurer = new RemoteFactoryProviderConfigurer();

    public final ReviewsClient getReviewClient(TaskRepository repository) {
        ReviewsClient client = this.clientForRepository.get(repository);
        if (client == null) {
            client = this.createReviewClient(repository, true);
            this.factoryProviderConfigurer.configure(client.getFactoryProvider());
            this.clientForRepository.put(repository, client);
        }
        return client;
    }

    protected abstract ReviewsClient createReviewClient(TaskRepository var1, boolean var2);

    public void setFactoryProviderConfigurer(RemoteFactoryProviderConfigurer factoryProviderConfigurer) {
        this.factoryProviderConfigurer = factoryProviderConfigurer;
    }

    public RemoteFactoryProviderConfigurer getFactoryProviderConfigurer() {
        return this.factoryProviderConfigurer;
    }

    public void updateTaskFromTaskData(TaskRepository taskRepository, ITask task, TaskData taskData) {
        if (TaskReviewsMappingsStore.getInstance() != null) {
            TaskReviewsMappingsStore.getInstance().addTaskAssocation(task, taskData);
        }
    }
}

