/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IResourceActionFilter;
import org.eclipse.ui.actions.SimpleWildcardTester;
import org.eclipse.ui.model.WorkbenchAdapter;

public abstract class WorkbenchResource
extends WorkbenchAdapter
implements IResourceActionFilter {
    protected abstract ImageDescriptor getBaseImage(IResource var1);

    public ImageDescriptor getImageDescriptor(Object o) {
        IResource resource = this.getResource(o);
        return resource == null ? null : this.getBaseImage(resource);
    }

    public String getLabel(Object o) {
        IResource resource = this.getResource(o);
        return resource == null ? null : resource.getName();
    }

    public Object getParent(Object o) {
        IResource resource = this.getResource(o);
        return resource == null ? null : resource.getParent();
    }

    protected IResource getResource(Object o) {
        return (IResource)Adapters.adapt((Object)o, IResource.class);
    }

    /*
     * WARNING - void declaration
     */
    public boolean testAttribute(Object target, String name, String value) {
        if (!(target instanceof IResource)) {
            return false;
        }
        IResource iResource = (IResource)target;
        switch (name) {
            case "name": {
                void res;
                return SimpleWildcardTester.testWildcardIgnoreCase((String)value, (String)res.getName());
            }
            case "path": {
                void res;
                return SimpleWildcardTester.testWildcardIgnoreCase((String)value, (String)res.getFullPath().toString());
            }
            case "extension": {
                void res;
                return SimpleWildcardTester.testWildcardIgnoreCase((String)value, (String)res.getFileExtension());
            }
            case "readOnly": {
                void res;
                return res.isReadOnly() == value.equalsIgnoreCase("true");
            }
            case "projectNature": {
                void res;
                try {
                    IProject proj = res.getProject();
                    return proj.isAccessible() && proj.hasNature(value);
                }
                catch (CoreException e) {
                    return false;
                }
            }
            case "persistentProperty": {
                void res;
                return this.testProperty((IResource)res, true, false, value);
            }
            case "projectPersistentProperty": {
                void res;
                return this.testProperty((IResource)res, true, true, value);
            }
            case "sessionProperty": {
                void res;
                return this.testProperty((IResource)res, false, false, value);
            }
            case "projectSessionProperty": {
                void res;
                return this.testProperty((IResource)res, false, true, value);
            }
            case "contentTypeId": {
                void res;
                return this.testContentTypeProperty((IResource)res, value);
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean testContentTypeProperty(IResource resource, String contentTypeId) {
        String expectedValue = contentTypeId.trim();
        if (!(resource instanceof IFile)) {
            return false;
        }
        IFile iFile = (IFile)resource;
        String actualValue = null;
        try {
            void file;
            IContentDescription contentDescription = file.getContentDescription();
            if (contentDescription != null) {
                IContentType contentType = contentDescription.getContentType();
                actualValue = contentType.getId();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return expectedValue == null || expectedValue.equals(actualValue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean testProperty(IResource resource, boolean persistentFlag, boolean projectFlag, String value) {
        String expectedVal;
        String propertyName;
        int i = value.indexOf(61);
        if (i != -1) {
            propertyName = value.substring(0, i).trim();
            expectedVal = value.substring(i + 1).trim();
        } else {
            propertyName = value.trim();
            expectedVal = null;
        }
        try {
            IResource resToCheck;
            int dot = propertyName.lastIndexOf(46);
            QualifiedName key = dot != -1 ? new QualifiedName(propertyName.substring(0, dot), propertyName.substring(dot + 1)) : new QualifiedName(null, propertyName);
            Object object = resToCheck = projectFlag ? resource.getProject() : resource;
            if (resToCheck == null) {
                return false;
            }
            if (persistentFlag) {
                String actualVal = resToCheck.getPersistentProperty(key);
                if (actualVal == null) {
                    return false;
                }
                return expectedVal == null || expectedVal.equals(actualVal);
            }
            Object actualVal = resToCheck.getSessionProperty(key);
            if (actualVal == null) {
                return false;
            }
            return expectedVal == null || expectedVal.equals(actualVal.toString());
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

