/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.confluence.internal.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Colors {
    private static final Pattern RGB_PATTERN = Pattern.compile("rgb\\(\\s*(\\d{1,3}+)\\s*,\\s*(\\d{1,3}+)\\s*,\\s*(\\d{1,3}+)\\s*\\)");

    public static String asHex(String color) {
        Matcher rgbMatcher = RGB_PATTERN.matcher(color);
        if (rgbMatcher.matches()) {
            return Colors.formatRgbAsHex(Colors.asInt(rgbMatcher.group(1)), Colors.asInt(rgbMatcher.group(2)), Colors.asInt(rgbMatcher.group(3)));
        }
        return color;
    }

    private static int asInt(String value) {
        return Integer.parseInt(value);
    }

    private static String formatRgbAsHex(int r, int g, int b) {
        return String.format("#%02x%02x%02x", r, g, b);
    }

    private Colors() {
    }
}

