/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ext.gmf.runtime.diagram.ui.tools;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.SharedCursors;
import org.eclipse.sirius.ext.gmf.runtime.diagram.ui.tools.MoveInDiagramDragTracker;
import org.eclipse.sirius.ext.gmf.runtime.diagram.ui.tools.RubberbandSelectionTool;
import org.eclipse.swt.events.MouseEvent;

public class RubberbandDragTracker
extends RubberbandSelectionTool
implements MoveInDiagramDragTracker {
    private Point previousMouseLocation;

    @Override
    protected boolean handleButtonDown(int button) {
        if (button == 2) {
            this.setCursor(SharedCursors.HAND);
            return this.stateTransition(1, 64);
        }
        return super.handleButtonDown(button);
    }

    public void mouseDrag(MouseEvent me, EditPartViewer viewer) {
        this.previousMouseLocation = this.getCurrentInput().getMouseLocation().getCopy();
        super.mouseDrag(me, viewer);
    }

    protected boolean handleDragStarted() {
        if (this.isInState(64)) {
            return this.stateTransition(64, 128);
        }
        return super.handleDragStarted();
    }

    @Override
    protected boolean handleDragInProgress() {
        if (this.isInState(128)) {
            if (this.getCurrentViewer().getControl() instanceof FigureCanvas) {
                FigureCanvas figureCanvas = (FigureCanvas)this.getCurrentViewer().getControl();
                Point currentMouseLocation = this.getCurrentInput().getMouseLocation();
                Dimension difference = this.previousMouseLocation.getDifference(currentMouseLocation);
                Point location = figureCanvas.getViewport().getViewLocation();
                figureCanvas.scrollTo(location.x + difference.width, location.y + difference.height);
            }
            return true;
        }
        return super.handleDragInProgress();
    }

    @Override
    protected void handleFinished() {
    }
}

