/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.asciidoc.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.asciidoc.internal.AsciiDocContentState;
import org.eclipse.mylyn.wikitext.parser.TableCellAttributes;

public class LanguageSupport {
    private static final Pattern COLUMN_FORMATTING_SPLITTER = Pattern.compile("([0-9]+)\\*(.*)");
    private static final Pattern ALIGN_PATTERN = Pattern.compile("((?:\\.)?)([<^>])");
    private static Pattern keyValuePattern = Pattern.compile("(.*)=\"(.*)\"");
    private static final Pattern SPLIT_PATTERN = Pattern.compile(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)");

    public static Map<String, String> parseFormattingProperties(String rawFormat, List<String> positionalParameters) {
        String[] valpairs;
        HashMap<String, String> properties = new HashMap<String, String>();
        if (rawFormat == null || rawFormat.trim().length() == 0) {
            return properties;
        }
        String[] stringArray = valpairs = SPLIT_PATTERN.split(rawFormat);
        int n = valpairs.length;
        int n2 = 0;
        while (n2 < n) {
            String pair = stringArray[n2];
            Matcher matcher = keyValuePattern.matcher(pair.trim());
            if (matcher.find()) {
                String key = matcher.group(1);
                String value = matcher.group(2);
                properties.put(key, value);
            } else if (!positionalParameters.isEmpty()) {
                properties.put(positionalParameters.remove(0), pair.trim());
            }
            ++n2;
        }
        return properties;
    }

    public static List<TableCellAttributes> computeColumnsAttributeList(String cols) {
        if (cols != null) {
            ArrayList<TableCellAttributes> result = new ArrayList<TableCellAttributes>();
            String[] stringArray = cols.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String c = stringArray[n2];
                Matcher matcher = COLUMN_FORMATTING_SPLITTER.matcher(c);
                if (matcher.matches()) {
                    int repeat = Integer.parseInt(matcher.group(1));
                    int i = 0;
                    while (i < repeat) {
                        result.add(LanguageSupport.convertToTableCellAttributes(matcher.group(2)));
                        ++i;
                    }
                } else {
                    result.add(LanguageSupport.convertToTableCellAttributes(c));
                }
                ++n2;
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static TableCellAttributes convertToTableCellAttributes(String columnFormat) {
        TableCellAttributes result = new TableCellAttributes();
        Matcher alignMatcher = ALIGN_PATTERN.matcher(columnFormat);
        int start = 0;
        while (alignMatcher.find(start)) {
            String align = alignMatcher.group(2);
            if (".".equals(alignMatcher.group(1))) {
                if ("<".equals(align)) {
                    result.setValign("top");
                } else if ("^".equals(align)) {
                    result.setValign("middle");
                } else if (">".equals(align)) {
                    result.setValign("bottom");
                }
            } else if ("<".equals(align)) {
                result.setAlign("left");
            } else if ("^".equals(align)) {
                result.setAlign("center");
            } else if (">".equals(align)) {
                result.setAlign("right");
            }
            start = alignMatcher.end();
        }
        return result;
    }

    public static List<TableCellAttributes> createDefaultColumnsAttributeList(int size) {
        ArrayList<TableCellAttributes> result = new ArrayList<TableCellAttributes>();
        int i = 0;
        while (i < size) {
            result.add(new TableCellAttributes());
            ++i;
        }
        return result;
    }

    public static int computeHeadingLevel(int initialLevel, AsciiDocContentState state) {
        int levelOffset;
        String attributeValue = state.getAttributeOrValue("leveloffset", "0");
        try {
            levelOffset = Integer.parseInt(attributeValue);
        }
        catch (NumberFormatException e) {
            return initialLevel;
        }
        return Math.max(1, Math.min(initialLevel + levelOffset, 6));
    }
}

