/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.notation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class ArrowType
extends AbstractEnumerator {
    public static final int NONE = 0;
    public static final int OPEN_ARROW = 1;
    public static final int SOLID_ARROW = 2;
    public static final ArrowType NONE_LITERAL = new ArrowType(0, "None", "None");
    public static final ArrowType OPEN_ARROW_LITERAL = new ArrowType(1, "OpenArrow", "OpenArrow");
    public static final ArrowType SOLID_ARROW_LITERAL = new ArrowType(2, "SolidArrow", "SolidArrow");
    private static final ArrowType[] VALUES_ARRAY = new ArrowType[]{NONE_LITERAL, OPEN_ARROW_LITERAL, SOLID_ARROW_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static ArrowType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ArrowType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ArrowType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ArrowType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ArrowType get(int value) {
        switch (value) {
            case 0: {
                return NONE_LITERAL;
            }
            case 1: {
                return OPEN_ARROW_LITERAL;
            }
            case 2: {
                return SOLID_ARROW_LITERAL;
            }
        }
        return null;
    }

    private ArrowType(int value, String name, String literal) {
        super(value, name, literal);
    }
}

