/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.occurrences;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightKind;
import org.eclipse.lsp4j.DocumentHighlightParams;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.findReferences.TargetURICollector;
import org.eclipse.xtext.findReferences.TargetURIs;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.occurrences.IDocumentHighlightService;
import org.eclipse.xtext.ide.server.occurrences.ITextRegionTransformer;
import org.eclipse.xtext.ide.util.DocumentHighlightComparator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.TextRegion;

@Singleton
public class DefaultDocumentHighlightService
implements IDocumentHighlightService {
    private static final Logger LOGGER = Logger.getLogger(DefaultDocumentHighlightService.class);
    private static final int UNUSED_VERSION = -1;
    private static final Predicate<EObject> AST_ROOT_FILTER = obj -> obj.eContainer() != null;
    @Inject
    protected EObjectAtOffsetHelper offsetHelper;
    @Inject
    protected ILocationInFileProvider locationInFileProvider;
    @Inject
    protected ITextRegionTransformer textRegionTransformer;
    @Inject
    private Provider<TargetURIs> targetURIsProvider;
    @Inject
    private IReferenceFinder referenceFinder;
    @Inject
    private TargetURICollector uriCollector;
    @Inject
    private DocumentHighlightComparator comparator;

    @Override
    public List<? extends DocumentHighlight> getDocumentHighlights(Document document, XtextResource resource, DocumentHighlightParams params, CancelIndicator cancelIndicator) {
        int offset = document.getOffSet(params.getPosition());
        return this.getDocumentHighlights(resource, offset);
    }

    public List<DocumentHighlight> getDocumentHighlights(XtextResource resource, int offset) {
        ITextRegion region;
        if (resource == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.warn((Object)"Resource was null.");
            }
            return Collections.emptyList();
        }
        URI uri = resource.getURI();
        if (offset < 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.warn((Object)("Invalid offset argument. Offset must be a non-negative integer for resource: " + String.valueOf(uri)));
            }
            return Collections.emptyList();
        }
        IParseResult parseResult = resource.getParseResult();
        if (parseResult == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.warn((Object)("Parse result was null for resource: " + String.valueOf(uri)));
            }
            return Collections.emptyList();
        }
        ICompositeNode rootNode = parseResult.getRootNode();
        String docContent = rootNode.getText();
        int docLength = docContent.length();
        if (offset >= docLength) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.warn((Object)("Offset exceeds document lenght. Document was " + docLength + " and offset was: " + offset + " for resource: " + String.valueOf(uri)));
            }
            return Collections.emptyList();
        }
        EObject selectedElement = this.offsetHelper.resolveElementAt(resource, offset);
        if (!this.isDocumentHighlightAvailableFor(selectedElement, resource, offset)) {
            return Collections.emptyList();
        }
        Supplier docSupplier = Suppliers.memoize(() -> new Document(-1, docContent));
        TargetURIs targetURIs = this.getTargetURIs(selectedElement);
        if (!(targetURIs instanceof TargetURIs)) {
            TargetURIs result = (TargetURIs)this.targetURIsProvider.get();
            result.addAllURIs(targetURIs);
            targetURIs = result;
        }
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        Acceptor2 acceptor = (source, sourceURI, eReference, index, targetOrProxy, targetURI) -> {
            ITextRegion region = this.locationInFileProvider.getSignificantTextRegion(source, (EStructuralFeature)eReference, index);
            if (!this.isNullOrEmpty(region)) {
                resultBuilder.add((Object)this.textRegionTransformer.apply((Document)docSupplier.get(), region, DocumentHighlightKind.Read));
            }
        };
        this.referenceFinder.findReferences((Predicate)targetURIs, (Resource)resource, (IReferenceFinder.Acceptor)acceptor, (IProgressMonitor)new NullProgressMonitor());
        if (resource.equals(selectedElement.eResource()) && !this.isNullOrEmpty(region = this.locationInFileProvider.getSignificantTextRegion(selectedElement))) {
            resultBuilder.add((Object)this.textRegionTransformer.apply((Document)docSupplier.get(), region, DocumentHighlightKind.Write));
        }
        return FluentIterable.from((Iterable)resultBuilder.build()).toSortedList((Comparator)this.comparator);
    }

    protected boolean isDocumentHighlightAvailableFor(EObject selectedElement, XtextResource resource, int offset) {
        EObject crossReferencedElement;
        if (selectedElement == null || !this.getSelectedElementFilter().apply((Object)selectedElement)) {
            return false;
        }
        INode crossReferenceNode = this.offsetHelper.getCrossReferenceNode(resource, (ITextRegion)new TextRegion(offset, 0));
        if (crossReferenceNode != null && (crossReferencedElement = this.offsetHelper.getCrossReferencedElement(crossReferenceNode)) != null && crossReferencedElement == selectedElement) {
            return true;
        }
        EObject containedElement = this.offsetHelper.resolveContainedElementAt(resource, offset);
        if (selectedElement == containedElement) {
            ITextRegion region = this.locationInFileProvider.getSignificantTextRegion(containedElement);
            return !this.isNullOrEmpty(region) && (region.contains(offset) || region.getOffset() + region.getLength() == offset);
        }
        return true;
    }

    protected Predicate<EObject> getSelectedElementFilter() {
        return AST_ROOT_FILTER;
    }

    protected Iterable<URI> getTargetURIs(EObject primaryTarget) {
        TargetURIs result = (TargetURIs)this.targetURIsProvider.get();
        this.uriCollector.add(primaryTarget, result);
        return result;
    }

    protected boolean isNullOrEmpty(ITextRegion region) {
        return region == null || ITextRegionWithLineInformation.EMPTY_REGION == region;
    }

    @FunctionalInterface
    private static interface Acceptor2
    extends IReferenceFinder.Acceptor {
        default public void accept(IReferenceDescription description) {
        }
    }
}

