/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.statevalue;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.IntegerStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.LongStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;

final class DoubleStateValue
extends TmfStateValue {
    private final double fValue;

    public DoubleStateValue(double value) {
        this.fValue = value;
    }

    @Override
    public ITmfStateValue.Type getType() {
        return ITmfStateValue.Type.DOUBLE;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof DoubleStateValue)) {
            return false;
        }
        DoubleStateValue other = (DoubleStateValue)object;
        return Double.compare(this.fValue, other.fValue) == 0;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.fValue);
        return (int)bits ^ (int)(bits >>> 32);
    }

    public @Nullable String toString() {
        return String.format("%3f", this.fValue);
    }

    @Override
    public double unboxDouble() {
        return this.fValue;
    }

    @Override
    public int compareTo(@Nullable ITmfStateValue other) {
        if (other == null) {
            throw new IllegalArgumentException();
        }
        switch (other.getType()) {
            case INTEGER: {
                double otherDoubleValue = ((IntegerStateValue)other).unboxInt();
                return Double.compare(this.fValue, otherDoubleValue);
            }
            case DOUBLE: {
                double otherDoubleValue = ((DoubleStateValue)other).unboxDouble();
                return Double.compare(this.fValue, otherDoubleValue);
            }
            case LONG: {
                double otherDoubleValue = ((LongStateValue)other).unboxLong();
                return Double.compare(this.fValue, otherDoubleValue);
            }
            case NULL: {
                return Double.compare(this.fValue, other.unboxDouble());
            }
            case STRING: {
                throw new StateValueTypeException("A Double state value cannot be compared to a String state value.");
            }
        }
        throw new StateValueTypeException("A Double state value cannot be compared to the type " + String.valueOf((Object)other.getType()));
    }

    @Override
    public @Nullable Object unboxValue() {
        return this.fValue;
    }
}

