/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gprof.action;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.dataviewers.abstractview.AbstractSTDataView;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTTreeViewer;
import org.eclipse.linuxtools.internal.gprof.Activator;
import org.eclipse.linuxtools.internal.gprof.Messages;
import org.eclipse.linuxtools.internal.gprof.parser.GmonDecoder;
import org.eclipse.linuxtools.internal.gprof.view.fields.SampleProfField;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;

public class SwitchSampleTimeAction
extends Action {
    private final AbstractSTDataView view;

    public SwitchSampleTimeAction(AbstractSTDataView view) {
        super(Messages.SwitchSampleTimeAction_SWITCH_SAMPLE_TIME, 2);
        this.setImageDescriptor(Activator.getImageDescriptor("icons/datetime_obj.gif"));
        this.setToolTipText(Messages.SwitchSampleTimeAction_SWITCH_SAMPLE_TIME);
        this.view = view;
    }

    public void run() {
        AbstractSTTreeViewer gmonViewer = (AbstractSTTreeViewer)this.view.getSTViewer();
        GmonDecoder decoder = (GmonDecoder)gmonViewer.getInput();
        if (decoder != null) {
            int prof_rate = decoder.getHistogramDecoder().getProfRate();
            if (prof_rate == 0) {
                MessageDialog.openError((Shell)this.view.getSite().getShell(), (String)Messages.SwitchSampleTimeAction_GMON_PROF_RATE_IS_NULL, (String)Messages.SwitchSampleTimeAction_GMON_PROF_RATE_IS_NULL_LONG_MSG);
                return;
            }
            TreeColumn tc = gmonViewer.getViewer().getTree().getColumn(1);
            SampleProfField spf = (SampleProfField)((Object)tc.getData());
            spf.toggle();
            tc.setText(spf.getColumnHeaderText());
            gmonViewer.getViewer().refresh();
        }
    }
}

