/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.gnu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;
import org.eclipse.cdt.make.core.scannerconfig.ScannerInfoTypes;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class GCCPerFileSIPConsoleParser
implements IScannerInfoConsoleParser {
    private static final String INCLUDE_PREAMBLE = "#include <...>";
    private static final String QUOTE_INCLUDE_PREAMBLE = "#include \"...\"";
    private static final String DEFINE_PREAMBLE = "#define";
    private static final String COMMAND_ID_BEGIN = "begin generating scanner info for scd_cmd_";
    private static final String COMMAND_ID_END = "end generating scanner info for scd_cmd_";
    private static final int NO_INCLUDES = 0;
    private static final int QUOTE_INCLUDES = 1;
    private static final int INCLUDES = 2;
    private IScannerInfoCollector fCollector = null;
    private int expectingIncludes = 0;
    private List<String> symbols;
    private List<String> includes;
    private List<String> quoteIncludes;
    private int commandId = -1;

    @Override
    public void startup(IProject project, IPath workingDirectory, IScannerInfoCollector collector, IMarkerGenerator markerGenerator) {
        this.fCollector = collector;
    }

    public boolean processLine(String line) {
        boolean rc = false;
        line = line.trim();
        TraceUtil.outputTrace("GCCPerFileSIPConsoleParser parsing line: [", line, "]");
        if (line.startsWith(COMMAND_ID_BEGIN)) {
            this.commandId = Integer.parseInt(line.substring(COMMAND_ID_BEGIN.length()));
            this.symbols = new ArrayList<String>();
            this.includes = new ArrayList<String>();
            this.quoteIncludes = new ArrayList<String>();
        } else if (line.startsWith(COMMAND_ID_END)) {
            HashMap<ScannerInfoTypes, List<String>> scannerInfo = new HashMap<ScannerInfoTypes, List<String>>();
            scannerInfo.put(ScannerInfoTypes.INCLUDE_PATHS, this.includes);
            scannerInfo.put(ScannerInfoTypes.QUOTE_INCLUDE_PATHS, this.quoteIncludes);
            scannerInfo.put(ScannerInfoTypes.SYMBOL_DEFINITIONS, this.symbols);
            this.fCollector.contributeToScannerConfig(this.commandId, scannerInfo);
            this.commandId = -1;
            rc = true;
        } else if (line.startsWith(DEFINE_PREAMBLE)) {
            String[] defineParts = line.split("\\s+", 3);
            if (defineParts[0].equals(DEFINE_PREAMBLE)) {
                Object symbol = null;
                switch (defineParts.length) {
                    case 2: {
                        symbol = defineParts[1];
                        break;
                    }
                    case 3: {
                        symbol = defineParts[1] + "=" + defineParts[2];
                    }
                }
                if (symbol != null && !this.symbols.contains(symbol)) {
                    this.symbols.add((String)symbol);
                }
            }
        } else if (line.startsWith(QUOTE_INCLUDE_PREAMBLE) && line.endsWith("search starts here:")) {
            this.expectingIncludes = 1;
        } else if (line.startsWith(INCLUDE_PREAMBLE) && line.endsWith("search starts here:")) {
            this.expectingIncludes = 2;
        } else if (line.startsWith("End of search list.")) {
            this.expectingIncludes = 0;
        } else if (this.expectingIncludes == 1) {
            if (!this.quoteIncludes.contains(line)) {
                this.quoteIncludes.add(line);
            }
        } else if (this.expectingIncludes == 2 && !this.includes.contains(line)) {
            this.includes.add(line);
        }
        return rc;
    }

    public void shutdown() {
    }
}

