/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.ui.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.internal.core.AdapterUtil;
import org.eclipse.cdt.internal.ui.util.AbstractResourceActionHandler;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.GeneratedMakefileBuilder;
import org.eclipse.cdt.managedbuilder.internal.ui.commands.Messages;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.viewers.IStructuredSelection;

public class CleanFilesHandler
extends AbstractResourceActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<IFile> selectedFiles = this.getSelectedBuildableFiles(event);
        if (selectedFiles.isEmpty()) {
            return null;
        }
        CleanFilesJob job = new CleanFilesJob(selectedFiles);
        job.schedule();
        return null;
    }

    private List<IFile> getSelectedBuildableFiles(ExecutionEvent event) throws ExecutionException {
        Collection selectedResources = CleanFilesHandler.getSelectedResources((ExecutionEvent)event);
        ArrayList<IFile> files = new ArrayList<IFile>(selectedResources.size());
        for (IResource resource : selectedResources) {
            if (!(resource instanceof IFile) || !CleanFilesHandler.isBuildable(resource)) continue;
            files.add((IFile)resource);
        }
        return files;
    }

    public void setEnabled(Object evaluationContext) {
        super.setEnabled(evaluationContext);
        this.setBaseEnabled(this.shouldBeEnabled());
    }

    private boolean shouldBeEnabled() {
        IPreferencesService preferences = Platform.getPreferencesService();
        if (preferences.getBoolean("org.eclipse.core.resources", "description.autobuilding", false, null)) {
            return false;
        }
        IStructuredSelection selection = this.getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        Iterator elements = selection.iterator();
        while (elements.hasNext()) {
            IFile file = (IFile)AdapterUtil.adapt(elements.next(), IFile.class);
            if (file == null) {
                return false;
            }
            if (CleanFilesHandler.isBuildable((IResource)file)) continue;
            return false;
        }
        return true;
    }

    private static boolean isBuildable(IResource resource) {
        IProject project = resource.getProject();
        if (!ManagedBuildManager.manages((IResource)project)) {
            return false;
        }
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        return buildInfo != null && buildInfo.isValid() && buildInfo.buildsFileType(resource.getFileExtension());
    }

    private static class CleanFilesJob
    extends Job {
        private final List<IFile> files;

        private CleanFilesJob(List<IFile> filesToBuild) {
            super(Messages.CleanFilesHandler_cleaningFiles);
            this.files = filesToBuild;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Class<?> clazz = ((Object)((Object)this)).getClass();
            synchronized (clazz) {
                Job[] buildJobs;
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Job[] jobArray = buildJobs = Job.getJobManager().find(ResourcesPlugin.FAMILY_MANUAL_BUILD);
                int n = buildJobs.length;
                int n2 = 0;
                while (n2 < n) {
                    Job job = jobArray[n2];
                    if (job != this && job instanceof CleanFilesJob) {
                        job.cancel();
                    }
                    ++n2;
                }
            }
            GeneratedMakefileBuilder builder = new GeneratedMakefileBuilder();
            return builder.cleanFiles(this.files, monitor);
        }

        public boolean belongsTo(Object family) {
            return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
        }
    }
}

