/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs;

import com.google.common.collect.Collections2;
import com.google.common.collect.LinkedHashMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.util.TimeGraphStyleUtil;
import org.eclipse.tracecompass.tmf.core.model.StyleProperties;
import org.eclipse.tracecompass.tmf.ui.colors.ColorUtils;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;

public class TimeGraphLegend
extends TitleAreaDialog {
    private static final ImageDescriptor RESET_IMAGE = Activator.getDefault().getImageDescripterFromPath("icons/ovr16/undo_edit.gif");
    private final ITimeGraphPresentationProvider fProvider;
    private final LocalResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private Composite fInnerComposite;

    public static void open(Shell parent, ITimeGraphPresentationProvider provider) {
        new TimeGraphLegend(parent, provider).open();
    }

    public TimeGraphLegend(Shell parent, ITimeGraphPresentationProvider provider) {
        super(parent);
        this.fProvider = provider;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected final ITimeGraphPresentationProvider getPresentationProvider() {
        return this.fProvider;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.addStateGroups(composite);
        this.setTitle(Messages.TmfTimeLegend_LEGEND);
        TimeGraphLegend.setDialogHelpAvailable((boolean)false);
        this.setHelpAvailable(false);
        parent.getShell().setMinimumSize(150, 150);
        composite.addDisposeListener(e -> this.fResourceManager.dispose());
        return composite;
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        Composite innerComposite = this.fInnerComposite;
        if (initialSize.y > Display.getDefault().getClientArea().height && innerComposite != null) {
            this.getShell().layout();
            TimeGraphLegend.getGridLayouts(innerComposite).forEach(gl -> {
                int n = gl.numColumns = 2;
            });
            initialSize = super.getInitialSize();
            Display.getDefault().asyncExec(() -> innerComposite.getParent().layout());
        }
        return initialSize;
    }

    private void addStateGroups(Composite composite) {
        Composite innerComposite;
        StateItem[] stateTable = this.fProvider.getStateTable();
        if (stateTable == null) {
            return;
        }
        List<StateItem> stateItems = Arrays.asList(stateTable);
        Collection linkStates = Collections2.filter(stateItems, TimeGraphLegend::isLinkState);
        final ScrolledComposite sc = new ScrolledComposite(composite, 768);
        sc.setLayoutData((Object)new GridData(4, 4, true, true));
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(200, 0).create());
        this.fInnerComposite = innerComposite = new Composite((Composite)sc, 0);
        GridData gd = new GridData(4, 4, true, true);
        innerComposite.setLayoutData((Object)gd);
        innerComposite.setLayout((Layout)new GridLayout());
        innerComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Point size = innerComposite.getSize();
                List<GridLayout> gridLayouts = TimeGraphLegend.getGridLayouts(innerComposite);
                Point minSize = new Point(0, 0);
                int columns = 8;
                while (columns > 0) {
                    int numColumns = columns--;
                    gridLayouts.forEach(gl -> {
                        int n2 = gl.numColumns = numColumns;
                    });
                    minSize = innerComposite.computeSize(-1, -1);
                    if (minSize.x <= size.x) break;
                }
                sc.setMinSize(0, minSize.y);
            }
        });
        sc.setContent((Control)innerComposite);
        this.createStatesGroup(innerComposite);
        this.createLinkGroup(linkStates, innerComposite);
        sc.setMinSize(0, innerComposite.computeSize((int)-1, (int)-1).y);
    }

    protected void createStatesGroup(Composite composite) {
        String stateTypeName = this.fProvider.getStateTypeName();
        StringBuilder buffer = new StringBuilder();
        if (!stateTypeName.isEmpty()) {
            buffer.append(stateTypeName);
            buffer.append(" ");
        }
        buffer.append(Messages.TmfTimeLegend_StateTypeName);
        StateItem[] stateTable = this.fProvider.getStateTable();
        List<Object> stateItems = stateTable != null ? Arrays.asList(stateTable) : Collections.emptyList();
        LinkedHashMultimap groupedStateItems = LinkedHashMultimap.create();
        for (StateItem stateItem : stateItems) {
            if (TimeGraphLegend.isLinkState(stateItem)) continue;
            Object group = stateItem.getStyleMap().get("style-group");
            if (group instanceof String) {
                groupedStateItems.put((Object)((String)group), (Object)stateItem);
                continue;
            }
            groupedStateItems.put((Object)buffer.toString(), (Object)stateItem);
        }
        for (String string : groupedStateItems.keySet()) {
            Collection groupItems = groupedStateItems.get((Object)string);
            this.createGroup(composite, string, groupItems);
        }
    }

    private static List<GridLayout> getGridLayouts(Composite innerComposite) {
        ArrayList<GridLayout> gridLayouts = new ArrayList<GridLayout>();
        if (innerComposite == null) {
            return gridLayouts;
        }
        Arrays.asList(innerComposite.getChildren()).forEach(control -> {
            Layout layout;
            if (control instanceof Composite && (layout = ((Composite)control).getLayout()) instanceof GridLayout) {
                gridLayouts.add((GridLayout)layout);
            }
        });
        return gridLayouts;
    }

    private void createLinkGroup(Collection<StateItem> linkStates, Composite composite) {
        if (linkStates.isEmpty()) {
            return;
        }
        this.createGroup(composite, this.fProvider.getLinkTypeName(), linkStates);
    }

    private void createGroup(Composite parent, String name, Collection<StateItem> stateItems) {
        Group group = new Group(parent, 0);
        group.setText(name);
        group.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginBottom = 10;
        group.setLayout((Layout)layout);
        for (StateItem stateItem : stateItems) {
            new LegendEntry((Composite)group, stateItem);
        }
    }

    protected static boolean isLinkState(StateItem si) {
        Object itemType = si.getStyleMap().getOrDefault(StyleProperties.itemTypeProperty(), StyleProperties.stateType());
        return itemType instanceof String && ((String)itemType).equals(StyleProperties.linkType());
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.TmfTimeLegend_LEGEND);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected class LegendEntry
    extends Composite {
        private static final String LEGEND_ENTRY_KEY = "legend.entry.key";
        private final Swatch fBar;
        private final Scale fScale;
        private final Button fReset;

        public LegendEntry(final Composite parent, final StateItem si) {
            super(parent, 0);
            final String bgColorKey = TimeGraphStyleUtil.getPreferenceName(TimeGraphLegend.this.fProvider, si, "background-color");
            final String heightFactorKey = TimeGraphStyleUtil.getPreferenceName(TimeGraphLegend.this.fProvider, si, "height");
            final String widthKey = TimeGraphStyleUtil.getPreferenceName(TimeGraphLegend.this.fProvider, si, "width");
            final IPreferenceStore store = TimeGraphStyleUtil.getStore();
            TimeGraphStyleUtil.loadValue(TimeGraphLegend.this.fProvider, si);
            String name = si.getStateString();
            this.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(4).create());
            this.fBar = new Swatch(this, si.getStateColor());
            this.fBar.setData(LEGEND_ENTRY_KEY, name);
            this.fBar.setToolTipText(Messages.TimeGraphLegend_swatchClick);
            this.fBar.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    Shell shell = new Shell();
                    ColorDialog cd = new ColorDialog(shell, 0);
                    cd.setRGB(LegendEntry.this.fBar.fColor.getRGB());
                    RGB color = cd.open();
                    if (color != null) {
                        store.setValue(bgColorKey, ColorUtils.toHexColor(color.red, color.green, color.blue));
                        LegendEntry.this.fBar.setColor(color);
                        si.setStateColor(color);
                        ((LegendEntry)LegendEntry.this).TimeGraphLegend.this.fProvider.refresh();
                        LegendEntry.this.fReset.setEnabled(true);
                    }
                }
            });
            this.fBar.addMouseTrackListener(new MouseTrackListener(){

                public void mouseHover(MouseEvent e) {
                }

                public void mouseExit(MouseEvent e) {
                    Shell shell = parent.getShell();
                    Cursor old = shell.getCursor();
                    shell.setCursor(new Cursor((Device)e.display, 0));
                    if (old != null) {
                        old.dispose();
                    }
                }

                public void mouseEnter(MouseEvent e) {
                    Shell shell = parent.getShell();
                    Cursor old = shell.getCursor();
                    shell.setCursor(new Cursor((Device)e.display, 21));
                    if (old != null) {
                        old.dispose();
                    }
                }
            });
            this.fBar.setLayoutData(GridDataFactory.swtDefaults().hint(30, 20).create());
            CLabel label = new CLabel(this, 0){

                protected String shortenText(GC gc, String t, int w) {
                    String text = super.shortenText(gc, t, w);
                    this.setToolTipText(t.equals(text) ? null : t);
                    return text;
                }
            };
            label.setData(LEGEND_ENTRY_KEY, (Object)name);
            label.setText(name);
            label.setLayoutData((Object)GridDataFactory.fillDefaults().hint(160, -1).align(4, 0x1000000).grab(true, false).create());
            label.setData("org.eclipse.e4.ui.css.CssClassName", (Object)"CLabelThemeTag");
            this.fScale = new Scale((Composite)this, 0);
            if (si.getStyleMap().get("width") instanceof Integer) {
                this.fScale.setMinimum(1);
                this.fScale.setMaximum(10);
                this.fScale.setSelection(si.getStateWidth());
            } else {
                this.fScale.setMinimum(1);
                this.fScale.setMaximum(100);
                this.fScale.setSelection((int)(100.0f * si.getStateHeightFactor()));
            }
            this.fScale.setToolTipText(Messages.TimeGraphLegend_widthTooltip);
            this.fScale.setData(LEGEND_ENTRY_KEY, (Object)name);
            this.fScale.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (si.getStyleMap().get("width") instanceof Integer) {
                        int newWidth = LegendEntry.this.fScale.getSelection();
                        store.setValue(widthKey, newWidth);
                        si.getStyleMap().put("width", newWidth);
                    } else {
                        float newHeight = (float)LegendEntry.this.fScale.getSelection() * 0.01f;
                        store.setValue(heightFactorKey, newHeight);
                        si.getStyleMap().put("height", Float.valueOf(newHeight));
                    }
                    ((LegendEntry)LegendEntry.this).TimeGraphLegend.this.fProvider.refresh();
                    LegendEntry.this.fReset.setEnabled(true);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.fScale.setLayoutData((Object)GridDataFactory.swtDefaults().hint(120, -1).create());
            this.fReset = new Button((Composite)this, 0x800000);
            this.fReset.setData(LEGEND_ENTRY_KEY, (Object)name);
            this.fReset.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    si.reset();
                    store.setToDefault(heightFactorKey);
                    store.setToDefault(widthKey);
                    store.setToDefault(bgColorKey);
                    LegendEntry.this.fBar.setColor(si.getStateColor());
                    if (si.getStyleMap().get("width") instanceof Integer) {
                        LegendEntry.this.fScale.setSelection(si.getStateWidth());
                    } else {
                        LegendEntry.this.fScale.setSelection((int)(100.0f * si.getStateHeightFactor()));
                    }
                    ((LegendEntry)LegendEntry.this).TimeGraphLegend.this.fProvider.refresh();
                    LegendEntry.this.fReset.setEnabled(false);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.fReset.setToolTipText(Messages.TimeGraphLegend_resetTooltip);
            this.fReset.setImage(RESET_IMAGE.createImage());
            this.fReset.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).create());
            if (store.getString(bgColorKey).equals(store.getDefaultString(bgColorKey)) && store.getFloat(heightFactorKey) == store.getDefaultFloat(heightFactorKey) && store.getInt(widthKey) == store.getDefaultInt(widthKey)) {
                this.fReset.setEnabled(false);
            }
        }

        public void dispose() {
            this.fReset.getImage().dispose();
            super.dispose();
        }
    }

    private class Swatch
    extends Canvas {
        private Color fColor;

        public Swatch(Composite parent, RGB rgb) {
            super(parent, 0x800000);
            this.fColor = TimeGraphLegend.this.fResourceManager.createColor(rgb);
            this.setForeground(this.fColor);
            this.addListener(9, event -> this.draw(event.gc));
        }

        public void setColor(RGB rgb) {
            if (rgb != null) {
                this.fColor = TimeGraphLegend.this.fResourceManager.createColor(rgb);
                this.setForeground(this.fColor);
                this.redraw();
            }
        }

        private void draw(GC gc) {
            Rectangle r = this.getClientArea();
            gc.setBackground(this.fColor);
            gc.fillRectangle(r);
            gc.setForeground(Display.getDefault().getSystemColor(2));
            gc.setLineWidth(2);
            gc.drawRectangle(1, 1, r.width - 2, r.height - 2);
        }
    }
}

