/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.breakpoint.actions;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.core.breakpointactions.ILogActionEnabler;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IFormattedValues;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;

public class MILogActionEnabler
implements ILogActionEnabler {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fServiceTracker;
    private final IDMContext fContext;

    public MILogActionEnabler(DsfExecutor executor, DsfServicesTracker serviceTracker, IDMContext context) {
        this.fExecutor = executor;
        this.fServiceTracker = serviceTracker;
        this.fContext = context;
    }

    public String evaluateExpression(final String expression) throws Exception {
        Query<String> query = new Query<String>(){

            protected void execute(final DataRequestMonitor<String> drm) {
                IExpressions expressionService = (IExpressions)MILogActionEnabler.this.fServiceTracker.getService(IExpressions.class);
                if (expressionService != null) {
                    IExpressions.IExpressionDMContext expressionDMC = expressionService.createExpression(MILogActionEnabler.this.fContext, expression);
                    String formatId = "NATURAL.Format";
                    IFormattedValues.FormattedValueDMContext valueDmc = expressionService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)expressionDMC, formatId);
                    expressionService.getFormattedExpressionValue(valueDmc, (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)MILogActionEnabler.this.fExecutor, drm){

                        protected void handleCompleted() {
                            Object result = expression + ": evaluation failed.";
                            if (this.isSuccess()) {
                                result = ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue();
                            }
                            drm.setData(result);
                            drm.done();
                        }
                    });
                }
            }
        };
        this.fExecutor.execute((Runnable)query);
        try {
            return (String)query.get();
        }
        catch (InterruptedException e) {
            return "Error evaluating \"" + expression + "\" (InterruptedException).";
        }
        catch (ExecutionException e) {
            return "Error evaluating \"" + expression + "\" (ExecutionException).";
        }
    }
}

