/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;
import java.util.Map;
import org.immutables.value.Value;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.jackson.UnixTimestampDeserializer;
import org.mandas.docker.client.jackson.UnixTimestampSerializer;
import org.mandas.docker.client.messages.ImmutableEvent;

@JsonDeserialize(builder=ImmutableEvent.Builder.class)
@Value.Immutable
@Value.Enclosing
public interface Event {
    @JsonProperty(value="Type")
    @Nullable
    public Type type();

    @JsonProperty(value="Action")
    @Nullable
    public String action();

    @JsonProperty(value="Actor")
    @Nullable
    public Actor actor();

    @JsonProperty(value="time")
    @JsonDeserialize(using=UnixTimestampDeserializer.class)
    @JsonSerialize(using=UnixTimestampSerializer.class)
    public Date time();

    @JsonProperty(value="timeNano")
    @Nullable
    public Long timeNano();

    public static Builder builder() {
        return ImmutableEvent.builder();
    }

    public static enum Type {
        CONTAINER("container"),
        IMAGE("image"),
        VOLUME("volume"),
        NETWORK("network"),
        DAEMON("daemon"),
        PLUGIN("plugin"),
        NODE("node"),
        SERVICE("service"),
        SECRET("secret"),
        CONFIG("config");

        private final String name;

        @JsonCreator
        private Type(String name) {
            this.name = name;
        }

        @JsonValue
        public String getName() {
            return this.name;
        }
    }

    @JsonDeserialize(builder=ImmutableEvent.Actor.Builder.class)
    @Value.Immutable
    public static interface Actor {
        @JsonProperty(value="ID")
        public String id();

        @JsonProperty(value="Attributes")
        @Nullable
        public Map<String, String> attributes();

        public static Actor create(String id, Map<String, String> attributes) {
            return ImmutableEvent.Actor.builder().id(id).attributes(attributes).build();
        }
    }

    public static interface Builder {
        public Builder type(Type var1);

        public Builder action(String var1);

        public Builder actor(Actor var1);

        public Builder time(Date var1);

        public Builder timeNano(Long var1);

        public Event build();
    }
}

