/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.teststubs.osgi.service.cm;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.virgo.teststubs.osgi.internal.Assert;
import org.eclipse.virgo.teststubs.osgi.service.cm.StubConfiguration;
import org.eclipse.virgo.teststubs.osgi.support.AbstractFilter;
import org.eclipse.virgo.teststubs.osgi.support.PropertiesFilter;
import org.eclipse.virgo.teststubs.osgi.support.TrueFilter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public final class StubConfigurationAdmin
implements ConfigurationAdmin {
    private final Map<String, Configuration> configurations = new HashMap<String, Configuration>();
    private final Object configurationsMonitor = new Object();

    public StubConfigurationAdmin() {
    }

    StubConfigurationAdmin(String pid, Configuration configuration) {
        this.configurations.put(pid, configuration);
    }

    public Configuration createFactoryConfiguration(String factoryPid) throws IOException {
        return this.createFactoryConfiguration(factoryPid, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration createFactoryConfiguration(String factoryPid, String location) throws IOException {
        Assert.assertNotNull(factoryPid, "factoryPid");
        Object object = this.configurationsMonitor;
        synchronized (object) {
            this.configurations.put(factoryPid, new StubConfiguration(this, null, factoryPid, location));
            return this.configurations.get(factoryPid);
        }
    }

    public Configuration getConfiguration(String pid) throws IOException {
        return this.getConfiguration(pid, null);
    }

    public StubConfiguration createConfiguration(String pid) throws IOException {
        return (StubConfiguration)this.getConfiguration(pid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration getConfiguration(String pid, String location) throws IOException {
        Assert.assertNotNull(pid, "pid");
        Object object = this.configurationsMonitor;
        synchronized (object) {
            if (!this.configurations.containsKey(pid)) {
                this.configurations.put(pid, new StubConfiguration(this, pid, null, location));
            }
            return this.configurations.get(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration[] listConfigurations(String filter) throws IOException, InvalidSyntaxException {
        Object object = this.configurationsMonitor;
        synchronized (object) {
            HashSet<Configuration> matches = new HashSet<Configuration>();
            AbstractFilter f = filter == null ? new TrueFilter() : new PropertiesFilter(filter);
            for (Configuration configuration : this.configurations.values()) {
                if (!this.isCurrent(configuration) || !f.match(configuration.getProperties())) continue;
                matches.add(configuration);
            }
            return matches.size() == 0 ? null : matches.toArray(new Configuration[matches.size()]);
        }
    }

    private boolean isCurrent(Configuration configuration) {
        return configuration.getProperties() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteConfiguration(String pid) {
        Object object = this.configurationsMonitor;
        synchronized (object) {
            this.configurations.remove(pid);
        }
    }

    public String toString() {
        return String.format("configurations: %s", this.configurations);
    }
}

