/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.ltk.core.refactoring.tests.participants;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public class FailingParticipant2 extends RenameParticipant {

	public static class Exception extends RuntimeException {
		/** This class is not intended to be serialized. */
		private static final long serialVersionUID= 1L;
	}

	/**
	 * {@inheritDoc}
	 */
	protected boolean initialize(Object element) {
		return true;
	}

	/**
	 * {@inheritDoc}
	 */
	public String getName() {
		return FailingParticipant2.class.getName();
	}

	/**
	 * {@inheritDoc}
	 */
	public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
		return new RefactoringStatus();
	}

	/**
	 * {@inheritDoc}
	 */
	public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
		return new NullChange() {
			public Change perform(IProgressMonitor monitor) throws CoreException {
				throw new Exception();
			}
		};
	}
}
