/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Common Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.help.ui.internal.search;
import org.eclipse.help.internal.base.*;
import org.eclipse.help.internal.search.*;
import org.eclipse.help.ui.internal.ide.*;
import org.eclipse.jface.action.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.search.ui.*;
import org.eclipse.search.ui.text.*;
import org.eclipse.swt.custom.*;
import org.eclipse.ui.*;
public class ResultPage extends AbstractTextSearchViewPage {
	final int SORT_BY_SCORE = 0;
	final int SORT_BY_TITLE = 1;
	private ResultTableContentProvider contentProvider;
	private SortAction currentSortAction;
	private SortAction sortByScoreAction;
	private SortAction sortByTitleAction;
	public ResultPage() {
		super(AbstractTextSearchViewPage.FLAG_LAYOUT_FLAT);
		sortByScoreAction = new SortAction(HelpIdeResources
				.getString("HelpSearchResultPage.score"), this, SORT_BY_SCORE); //$NON-NLS-1$
		sortByTitleAction = new SortAction(HelpIdeResources
				.getString("HelpSearchResultPage.title"), this, SORT_BY_TITLE); //$NON-NLS-1$
		currentSortAction = sortByScoreAction;
	}
	protected void showMatch(Match match, int currentOffset, int currentLength,
			boolean activate) throws PartInitException {
		// TODO - honor activate flag (ref bug 51345)
		Object element = match.getElement();
		try {
			final SearchHit hit = (SearchHit) element;
			HelpSearchQuery query = (HelpSearchQuery) ((HelpSearchResult) getInput())
					.getQuery();
			final String urlQuery = query.getQueryData().toURLQuery();
			BusyIndicator.showWhile(null, new Runnable() {
				public void run() {
					try {
						BaseHelpSystem.getHelpDisplay().displaySearch(urlQuery,
								hit.getHref(), false);
					} catch (Exception e) {
					}
				}
			});
		} catch (Exception e) {
		}
	}
	protected void elementsChanged(Object[] objects) {
		if (contentProvider != null)
			contentProvider.elementsChanged(objects);
	}
	protected void clear() {
		if (contentProvider != null)
			contentProvider.clear();
	}
	protected void configureTreeViewer(TreeViewer viewer) {
		throw new IllegalStateException(this.getClass().getName()
				+ " doesn't support tree mode."); //$NON-NLS-1$
	}
	protected void configureTableViewer(TableViewer viewer) {
		viewer.setSorter(new SorterByScore());
		viewer.setLabelProvider(new ResultTableLabelProvider());
		contentProvider = new ResultTableContentProvider();
		viewer.setContentProvider(contentProvider);
	}
	protected void fillContextMenu(IMenuManager mgr) {
		super.fillContextMenu(mgr);
		addSortActions(mgr);
	}
	private void addSortActions(IMenuManager mgr) {
		if (getLayout() != FLAG_LAYOUT_FLAT)
			return;
		MenuManager sortMenu = new MenuManager(HelpIdeResources
				.getString("HelpSearchResultPage.sortBy")); //$NON-NLS-1$
		sortMenu.add(sortByScoreAction);
		sortMenu.add(sortByTitleAction);
		sortByScoreAction.setChecked(currentSortAction == sortByScoreAction);
		sortByTitleAction.setChecked(currentSortAction == sortByTitleAction);
		mgr.appendToGroup(IContextMenuConstants.GROUP_VIEWER_SETUP, sortMenu);
	}
	public void setSortOrder(SortAction action) {
		currentSortAction = action;
		StructuredViewer viewer = getViewer();
		if (action.getSortOrder() == SORT_BY_SCORE) {
			viewer.setSorter(new SorterByScore());
		} else {
			viewer.setSorter(new SorterByTitle());
		}
	}
}