/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.tests.verifier;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.MessageHelper;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.tests.verifier.Activator;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.packageadmin.PackageAdmin;

public class VerifierApplication
implements IApplication {
    private static final File DEFAULT_PROPERTIES_FILE = new File("verifier.properties");
    private static final String ARG_PROPERTIES = "-verifier.properties";
    private Properties properties = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private static IStatus createError(String message) {
        return new Status(4, "org.eclipse.equinox.p2.tests.verifier", message);
    }

    public static Bundle getBundle(String symbolicName) {
        PackageAdmin packageAdmin;
        BundleContext bundleContext = Activator.getBundleContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((packageAdmin = (PackageAdmin)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            return null;
        }
        Bundle[] bundles = packageAdmin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    public Object start(IApplicationContext context) throws Exception {
        VerifierApplication.getBundle("org.eclipse.equinox.p2.exemplarysetup").start(1);
        String[] args = (String[])context.getArguments().get("application.args");
        this.processArguments(args);
        IStatus result = this.verify();
        if (!result.isOK()) {
            LogHelper.log((IStatus)result);
        }
        return result.isOK() ? IApplication.EXIT_OK : new Integer(13);
    }

    private void processArguments(String[] args) {
        if (args == null) {
            return;
        }
        int i = 1;
        while (i < args.length) {
            String filename;
            if (ARG_PROPERTIES.equals(args[i - 1]) && !(filename = args[i]).startsWith("-")) {
                try {
                    this.properties = this.readProperties(new File(filename));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        if (this.properties == null) {
            try {
                if (DEFAULT_PROPERTIES_FILE.exists()) {
                    this.properties = this.readProperties(DEFAULT_PROPERTIES_FILE);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.properties == null) {
            this.properties = new Properties();
        }
    }

    private Properties readProperties(File file) throws IOException {
        Properties properties;
        block7: {
            Properties result = new Properties();
            InputStream input = null;
            try {
                input = new BufferedInputStream(new FileInputStream(file));
                result.load(input);
                properties = result;
                if (input == null) break block7;
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        return properties;
    }

    public void stop() {
    }

    private List getAllBundles() {
        BundleContext bundleContext = Activator.getBundleContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformAdmin platformAdmin = (PlatformAdmin)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
        BundleContext bundleContext2 = Activator.getBundleContext();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PackageAdmin packageAdmin = (PackageAdmin)ServiceHelper.getService((BundleContext)bundleContext2, (String)clazz2.getName());
        State state = platformAdmin.getState(false);
        ArrayList<Bundle> result = new ArrayList<Bundle>();
        BundleDescription[] bundles = state.getBundles();
        int i = 0;
        while (i < bundles.length) {
            BundleDescription bundle = bundles[i];
            Bundle[] versions = packageAdmin.getBundles(bundle.getSymbolicName(), bundle.getVersion().toString());
            int j = 0;
            while (j < versions.length) {
                result.add(versions[j]);
                ++j;
            }
            ++i;
        }
        return result;
    }

    private IStatus checkResolved() {
        String generalMessage;
        ArrayList<IStatus> allProblems = new ArrayList<IStatus>();
        BundleContext bundleContext = Activator.getBundleContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformAdmin platformAdmin = (PlatformAdmin)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
        State state = platformAdmin.getState(false);
        StateHelper stateHelper = platformAdmin.getStateHelper();
        VersionConstraint[] leafConstraints = stateHelper.getUnsatisfiedLeaves(state.getBundles());
        HashMap<BundleDescription, ArrayList<VersionConstraint>> missing = new HashMap<BundleDescription, ArrayList<VersionConstraint>>();
        int i = 0;
        while (i < leafConstraints.length) {
            if (!(leafConstraints[i] instanceof BundleSpecification && ((BundleSpecification)leafConstraints[i]).isOptional() || leafConstraints[i] instanceof ImportPackageSpecification && ("optional".equals(((ImportPackageSpecification)leafConstraints[i]).getDirective("resolution")) || "dynamic".equals(((ImportPackageSpecification)leafConstraints[i]).getDirective("resolution"))))) {
                BundleDescription bundleDesc = leafConstraints[i].getBundle();
                ArrayList<VersionConstraint> constraints = (ArrayList<VersionConstraint>)missing.get(bundleDesc);
                if (constraints == null) {
                    constraints = new ArrayList<VersionConstraint>();
                    missing.put(bundleDesc, constraints);
                }
                constraints.add(leafConstraints[i]);
            }
            ++i;
        }
        if (missing.size() > 0) {
            int rootIndex = 0;
            Iterator iter = missing.keySet().iterator();
            while (iter.hasNext()) {
                BundleDescription description = (BundleDescription)iter.next();
                generalMessage = NLS.bind((String)EclipseAdaptorMsg.ECLIPSE_STARTUP_ERROR_BUNDLE_NOT_RESOLVED, (Object)description.getLocation());
                ArrayList constraints = (ArrayList)missing.get(description);
                Iterator inner = constraints.iterator();
                while (inner.hasNext()) {
                    String message = String.valueOf(generalMessage) + " Reason: " + MessageHelper.getResolutionFailureMessage((VersionConstraint)((VersionConstraint)inner.next()));
                    allProblems.add(VerifierApplication.createError(message));
                }
                ++rootIndex;
            }
        }
        List allBundles = this.getAllBundles();
        Iterator i2 = allBundles.iterator();
        while (i2.hasNext()) {
            Bundle bundle = (Bundle)i2.next();
            if (bundle.getState() != 2) continue;
            generalMessage = NLS.bind((String)EclipseAdaptorMsg.ECLIPSE_STARTUP_ERROR_BUNDLE_NOT_RESOLVED, (Object)bundle);
            BundleDescription description = state.getBundle(bundle.getBundleId());
            if (description == null) continue;
            VersionConstraint[] unsatisfied = stateHelper.getUnsatisfiedConstraints(description);
            if (unsatisfied.length > 0) {
                int j = 0;
                while (j < unsatisfied.length) {
                    allProblems.add(VerifierApplication.createError(String.valueOf(generalMessage) + " Reason: " + MessageHelper.getResolutionFailureMessage((VersionConstraint)unsatisfied[j])));
                    ++j;
                }
                continue;
            }
            ResolverError[] resolverErrors = state.getResolverErrors(description);
            int j = 0;
            while (j < resolverErrors.length) {
                if (this.shouldAdd(resolverErrors[j])) {
                    allProblems.add(VerifierApplication.createError(String.valueOf(generalMessage) + " Reason: " + resolverErrors[j].toString()));
                }
                ++j;
            }
        }
        MultiStatus result = new MultiStatus("org.eclipse.equinox.p2.tests.verifier", 0, "Problems checking resolved bundles.", null);
        Iterator iter = allProblems.iterator();
        while (iter.hasNext()) {
            result.add((IStatus)iter.next());
        }
        return result;
    }

    private boolean shouldAdd(ResolverError error) {
        boolean ignoreEE;
        String prop = this.properties.getProperty("ignore.ee");
        boolean bl = ignoreEE = prop == null || Boolean.valueOf(prop) != false;
        return 16384 != error.getType() || !ignoreEE;
    }

    private IStatus checkProfileRegistry() {
        IProfileRegistry registry;
        BundleContext bundleContext = Activator.getBundleContext();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((registry = (IProfileRegistry)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            return VerifierApplication.createError("Profile registry service not available.");
        }
        IProfile profile = registry.getProfile("_SELF_");
        if (profile == null) {
            return VerifierApplication.createError("SELF profile not available in profile registry.");
        }
        Collector results = profile.query((Query)new InstallableUnitQuery("org.eclipse.equinox.p2.tests.verifier"), new Collector(), null);
        if (results.isEmpty()) {
            return VerifierApplication.createError(NLS.bind((String)"IU for {0} not found in SELF profile.", (Object)"org.eclipse.equinox.p2.tests.verifier"));
        }
        return Status.OK_STATUS;
    }

    public IStatus verify() {
        String message = "Problems occurred during verification.";
        MultiStatus result = new MultiStatus("org.eclipse.equinox.p2.tests.verifier", 0, message, null);
        IStatus temp = this.checkResolved();
        if (!temp.isOK()) {
            result.merge(temp);
        }
        if (!(temp = this.checkProfileRegistry()).isOK()) {
            result.merge(temp);
        }
        return result;
    }
}

