/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.prov.engine;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.prov.core.helpers.MultiStatus;
import org.eclipse.equinox.prov.engine.EngineSession;
import org.eclipse.equinox.prov.engine.Operand;
import org.eclipse.equinox.prov.engine.Phase;
import org.eclipse.equinox.prov.engine.Profile;

public abstract class IUPhase
extends Phase {
    protected int PRE_PERFORM_WORK = 1000;
    protected int PERFORM_WORK = 10000;
    protected int POST_PERFORM_WORK = 1000;

    protected IUPhase(String phaseId, int weight, String phaseName) {
        super(phaseId, weight, phaseName);
    }

    protected void perform(MultiStatus status, EngineSession session, Profile profile, Operand[] operands, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.PRE_PERFORM_WORK + this.PERFORM_WORK + this.POST_PERFORM_WORK));
        this.prePerform(status, profile, operands, (IProgressMonitor)subMonitor.newChild(this.PRE_PERFORM_WORK));
        if (status.isErrorOrCancel()) {
            return;
        }
        subMonitor.setWorkRemaining(this.PERFORM_WORK + this.POST_PERFORM_WORK);
        this.mainPerform(status, session, profile, operands, subMonitor.newChild(this.PERFORM_WORK));
        if (status.isErrorOrCancel()) {
            return;
        }
        subMonitor.setWorkRemaining(this.POST_PERFORM_WORK);
        this.postPerform(status, profile, operands, (IProgressMonitor)subMonitor.newChild(this.POST_PERFORM_WORK));
        if (status.isErrorOrCancel()) {
            return;
        }
        subMonitor.done();
    }

    protected void mainPerform(MultiStatus status, EngineSession session, Profile profile, Operand[] operands, SubMonitor subMonitor) {
        int operandWork = this.PERFORM_WORK / operands.length;
        int i = 0;
        while (i < operands.length) {
            if (subMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            Operand currentOperand = operands[i];
            if (this.isApplicable(currentOperand)) {
                IStatus result = this.performOperand(session, profile, currentOperand, (IProgressMonitor)subMonitor.newChild(operandWork));
                status.add(result);
                if (status.isErrorOrCancel()) {
                    return;
                }
            }
            ++i;
        }
    }

    protected abstract boolean isApplicable(Operand var1);

    protected abstract IStatus performOperand(EngineSession var1, Profile var2, Operand var3, IProgressMonitor var4);

    protected void prePerform(MultiStatus status, Profile profile, Operand[] deltas, IProgressMonitor monitor) {
    }

    protected void postPerform(MultiStatus status, Profile profile, Operand[] deltas, IProgressMonitor monitor) {
    }
}

