/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.jacoco.report.IMultiReportOutput;
import org.jacoco.report.NormalizedFileNames;

public class ReportOutputFolder {
    private final IMultiReportOutput output;
    private final ReportOutputFolder parent;
    private final String path;
    private final Map<String, ReportOutputFolder> subFolders = new HashMap<String, ReportOutputFolder>();
    private final NormalizedFileNames fileNames;

    public ReportOutputFolder(IMultiReportOutput output) {
        this(output, null, "");
    }

    private ReportOutputFolder(IMultiReportOutput output, ReportOutputFolder parent, String path) {
        this.output = output;
        this.parent = parent;
        this.path = path;
        this.fileNames = new NormalizedFileNames();
    }

    public ReportOutputFolder subFolder(String name) {
        String normalizedName = this.normalize(name);
        ReportOutputFolder folder = this.subFolders.get(normalizedName);
        if (folder != null) {
            return folder;
        }
        folder = new ReportOutputFolder(this.output, this, this.path + normalizedName + "/");
        this.subFolders.put(normalizedName, folder);
        return folder;
    }

    public OutputStream createFile(String name) throws IOException {
        return this.output.createFile(this.path + this.normalize(name));
    }

    public String getLink(ReportOutputFolder base, String name) {
        if (base.isAncestorOf(this)) {
            return this.path.substring(base.path.length()) + this.normalize(name);
        }
        if (base.parent == null) {
            throw new IllegalArgumentException("Folders with different roots.");
        }
        return "../" + this.getLink(base.parent, name);
    }

    private boolean isAncestorOf(ReportOutputFolder folder) {
        if (this == folder) {
            return true;
        }
        return folder.parent == null ? false : this.isAncestorOf(folder.parent);
    }

    private String normalize(String name) {
        return this.fileNames.getFileName(name);
    }
}

