/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.parsers.custom;

import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventType;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfEvent;
import org.eclipse.linuxtools.tmf.core.event.TmfEventType;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomEvent;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomTraceDefinition;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomXmlEventType;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomXmlTraceDefinition;

public class CustomXmlEvent
extends CustomEvent {
    public CustomXmlEvent(CustomXmlTraceDefinition definition) {
        super(definition);
        this.setType((ITmfEventType)new CustomXmlEventType(definition));
    }

    public CustomXmlEvent(CustomXmlTraceDefinition definition, TmfEvent other) {
        super(definition, other);
    }

    public CustomXmlEvent(CustomXmlTraceDefinition definition, ITmfTrace<?> parentTrace, ITmfTimestamp timestamp, String source, TmfEventType type, String reference) {
        super(definition, parentTrace, timestamp, source, type, reference);
    }

    public void setContent(ITmfEventField content) {
        super.setContent(content);
    }

    public void parseInput(String value, String name, int inputAction, String inputFormat) {
        if (value.length() == 0) {
            return;
        }
        if (inputAction == 0) {
            this.fData.put(name, value);
            if (name.equals(CustomTraceDefinition.TAG_TIMESTAMP)) {
                this.fData.put("CE_TS_I_F", inputFormat);
            }
        } else if (inputAction == 1) {
            String s = (String)this.fData.get(name);
            if (s != null) {
                this.fData.put(name, String.valueOf(s) + value);
            } else {
                this.fData.put(name, value);
            }
            if (name.equals(CustomTraceDefinition.TAG_TIMESTAMP)) {
                String timeStampInputFormat = (String)this.fData.get("CE_TS_I_F");
                if (timeStampInputFormat != null) {
                    this.fData.put("CE_TS_I_F", String.valueOf(timeStampInputFormat) + inputFormat);
                } else {
                    this.fData.put("CE_TS_I_F", inputFormat);
                }
            }
        } else if (inputAction == 2) {
            String s = (String)this.fData.get(name);
            if (s != null) {
                this.fData.put(name, String.valueOf(s) + " | " + value);
            } else {
                this.fData.put(name, value);
            }
            if (name.equals(CustomTraceDefinition.TAG_TIMESTAMP)) {
                String timeStampInputFormat = (String)this.fData.get("CE_TS_I_F");
                if (timeStampInputFormat != null) {
                    this.fData.put("CE_TS_I_F", String.valueOf(timeStampInputFormat) + " | " + inputFormat);
                } else {
                    this.fData.put("CE_TS_I_F", inputFormat);
                }
            }
        }
    }
}

