/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.marte.hrm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CacheType implements Enumerator
{
    DATA(0, "data", "data"),
    INSTRUCTION(1, "instruction", "instruction"),
    UNIFIED(2, "unified", "unified"),
    OTHER(3, "other", "other"),
    UNDEF(4, "undef", "undef");

    public static final int DATA_VALUE = 0;
    public static final int INSTRUCTION_VALUE = 1;
    public static final int UNIFIED_VALUE = 2;
    public static final int OTHER_VALUE = 3;
    public static final int UNDEF_VALUE = 4;
    private static final CacheType[] VALUES_ARRAY;
    public static final List<CacheType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CacheType[]{DATA, INSTRUCTION, UNIFIED, OTHER, UNDEF};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CacheType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CacheType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CacheType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CacheType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CacheType get(int value) {
        switch (value) {
            case 0: {
                return DATA;
            }
            case 1: {
                return INSTRUCTION;
            }
            case 2: {
                return UNIFIED;
            }
            case 3: {
                return OTHER;
            }
            case 4: {
                return UNDEF;
            }
        }
        return null;
    }

    private CacheType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

