/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.base;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Resources;

public abstract class JDTChange
extends Change {
    private long fModificationStamp = -1L;
    private boolean fReadOnly = false;
    protected static final int NONE = 0;
    protected static final int READ_ONLY = 1;
    protected static final int DIRTY = 2;
    private static final int SAVE = 4;
    protected static final int SAVE_IF_DIRTY = 6;

    protected JDTChange() {
    }

    public void initializeValidationData(IProgressMonitor pm) {
        IResource resource = JDTChange.getResource(this.getModifiedElement());
        if (resource != null) {
            this.fModificationStamp = this.getModificationStamp(resource);
            this.fReadOnly = Resources.isReadOnly(resource);
        }
    }

    protected final RefactoringStatus isValid(IProgressMonitor pm, int flags) throws CoreException {
        pm.beginTask("", 2);
        try {
            RefactoringStatus result = new RefactoringStatus();
            Object modifiedElement = this.getModifiedElement();
            JDTChange.checkExistence(result, modifiedElement);
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            if (flags == 0) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            IResource resource = JDTChange.getResource(modifiedElement);
            if (resource != null) {
                ValidationState state = new ValidationState(resource);
                state.checkModificationStamp(result, this.fModificationStamp);
                if (result.hasFatalError()) {
                    RefactoringStatus refactoringStatus = result;
                    return refactoringStatus;
                }
                state.checkSameReadOnly(result, this.fReadOnly);
                if (result.hasFatalError()) {
                    RefactoringStatus refactoringStatus = result;
                    return refactoringStatus;
                }
                if ((flags & 1) != 0) {
                    state.checkReadOnly(result);
                    if (result.hasFatalError()) {
                        RefactoringStatus refactoringStatus = result;
                        return refactoringStatus;
                    }
                }
                if ((flags & 2) != 0) {
                    if ((flags & 4) != 0) {
                        state.checkDirty(result, this.fModificationStamp, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    } else {
                        state.checkDirty(result);
                    }
                }
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    protected static void checkIfModifiable(RefactoringStatus status, Object element, int flags) {
        JDTChange.checkIfModifiable(status, JDTChange.getResource(element), flags);
    }

    protected static void checkIfModifiable(RefactoringStatus result, IResource resource, int flags) {
        JDTChange.checkExistence(result, resource);
        if (result.hasFatalError()) {
            return;
        }
        if (flags == 0) {
            return;
        }
        ValidationState state = new ValidationState(resource);
        if ((flags & 1) != 0) {
            state.checkReadOnly(result);
            if (result.hasFatalError()) {
                return;
            }
        }
        if ((flags & 2) != 0) {
            state.checkDirty(result);
        }
    }

    protected static void checkExistence(RefactoringStatus status, Object element) {
        if (element == null) {
            status.addFatalError(RefactoringCoreMessages.DynamicValidationStateChange_workspace_changed);
        } else if (element instanceof IResource && !((IResource)element).exists()) {
            status.addFatalError(Messages.format(RefactoringCoreMessages.Change_does_not_exist, ((IResource)element).getFullPath().toString()));
        } else if (element instanceof IJavaScriptElement && !((IJavaScriptElement)element).exists()) {
            status.addFatalError(Messages.format(RefactoringCoreMessages.Change_does_not_exist, ((IJavaScriptElement)element).getElementName()));
        }
    }

    private static IResource getResource(Object element) {
        if (element instanceof IResource) {
            return (IResource)element;
        }
        if (element instanceof IJavaScriptUnit) {
            return ((IJavaScriptUnit)element).getPrimary().getResource();
        }
        if (element instanceof IJavaScriptElement) {
            return ((IJavaScriptElement)element).getResource();
        }
        if (element instanceof IAdaptable) {
            return (IResource)((IAdaptable)element).getAdapter(IResource.class);
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public long getModificationStamp(IResource resource) {
        if (!(resource instanceof IFile)) {
            return resource.getModificationStamp();
        }
        IFile file = (IFile)resource;
        ITextFileBuffer buffer = JDTChange.getBuffer(file);
        if (buffer == null) {
            return file.getModificationStamp();
        }
        IDocument document = buffer.getDocument();
        if (document instanceof IDocumentExtension4) {
            return ((IDocumentExtension4)document).getModificationStamp();
        }
        return file.getModificationStamp();
    }

    private static ITextFileBuffer getBuffer(IFile file) {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        return manager.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
    }

    private static class ValidationState {
        private IResource fResource;
        private int fKind;
        private boolean fDirty;
        private boolean fReadOnly;
        private long fModificationStamp;
        private ITextFileBuffer fTextFileBuffer;
        public static final int RESOURCE = 1;
        public static final int DOCUMENT = 2;

        public ValidationState(IResource resource) {
            this.fResource = resource;
            if (resource instanceof IFile) {
                this.initializeFile((IFile)resource);
            } else {
                this.initializeResource(resource);
            }
        }

        public void checkDirty(RefactoringStatus status, long stampToMatch, IProgressMonitor pm) throws CoreException {
            if (this.fDirty) {
                if (this.fKind == 2 && this.fTextFileBuffer != null && stampToMatch == this.fModificationStamp) {
                    this.fTextFileBuffer.commit(pm, false);
                } else {
                    status.addFatalError(Messages.format(RefactoringCoreMessages.Change_is_unsaved, this.fResource.getFullPath().toString()));
                }
            }
        }

        public void checkDirty(RefactoringStatus status) {
            if (this.fDirty) {
                status.addFatalError(Messages.format(RefactoringCoreMessages.Change_is_unsaved, this.fResource.getFullPath().toString()));
            }
        }

        public void checkReadOnly(RefactoringStatus status) {
            if (this.fReadOnly) {
                status.addFatalError(Messages.format(RefactoringCoreMessages.Change_is_read_only, this.fResource.getFullPath().toString()));
            }
        }

        public void checkSameReadOnly(RefactoringStatus status, boolean valueToMatch) {
            if (this.fReadOnly != valueToMatch) {
                status.addFatalError(Messages.format(RefactoringCoreMessages.Change_same_read_only, this.fResource.getFullPath().toString()));
            }
        }

        public void checkModificationStamp(RefactoringStatus status, long stampToMatch) {
            if (this.fKind == 2) {
                if (stampToMatch != -1L && this.fModificationStamp != stampToMatch) {
                    status.addFatalError(Messages.format(RefactoringCoreMessages.Change_has_modifications, this.fResource.getFullPath().toString()));
                }
            } else if (stampToMatch != -1L && this.fModificationStamp != stampToMatch) {
                status.addFatalError(Messages.format(RefactoringCoreMessages.Change_has_modifications, this.fResource.getFullPath().toString()));
            }
        }

        private void initializeFile(IFile file) {
            this.fTextFileBuffer = JDTChange.getBuffer(file);
            if (this.fTextFileBuffer == null) {
                this.initializeResource((IResource)file);
            } else {
                IDocument document = this.fTextFileBuffer.getDocument();
                this.fDirty = this.fTextFileBuffer.isDirty();
                this.fReadOnly = Resources.isReadOnly((IResource)file);
                if (document instanceof IDocumentExtension4) {
                    this.fKind = 2;
                    this.fModificationStamp = ((IDocumentExtension4)document).getModificationStamp();
                } else {
                    this.fKind = 1;
                    this.fModificationStamp = file.getModificationStamp();
                }
            }
        }

        private void initializeResource(IResource resource) {
            this.fKind = 1;
            this.fDirty = false;
            this.fReadOnly = Resources.isReadOnly(resource);
            this.fModificationStamp = resource.getModificationStamp();
        }
    }
}

