/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.model.tree;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;

public class TmfTreeDataModel
implements ITmfTreeDataModel {
    private final long fId;
    private final long fParentId;
    private final List<String> fLabels;
    private final boolean fHasRowModel;
    private final @Nullable OutputElementStyle fStyle;

    public TmfTreeDataModel(long id, long parentId, String name) {
        this(id, parentId, Collections.singletonList(name), true, null);
    }

    public TmfTreeDataModel(long id, long parentId, List<String> labels) {
        this(id, parentId, labels, true, null);
    }

    public TmfTreeDataModel(long id, long parentId, List<String> labels, boolean hasRowModel, @Nullable OutputElementStyle style) {
        this.fId = id;
        this.fParentId = parentId;
        this.fLabels = labels;
        this.fHasRowModel = hasRowModel;
        this.fStyle = style;
    }

    @Override
    public long getId() {
        return this.fId;
    }

    @Override
    public long getParentId() {
        return this.fParentId;
    }

    @Override
    public String getName() {
        return this.fLabels.isEmpty() ? "" : this.fLabels.get(0);
    }

    @Override
    public List<String> getLabels() {
        return this.fLabels;
    }

    @Override
    public boolean hasRowModel() {
        return this.fHasRowModel;
    }

    @Override
    public @Nullable OutputElementStyle getStyle() {
        return this.fStyle;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TmfTreeDataModel other = (TmfTreeDataModel)obj;
        return this.fId == other.fId && this.fParentId == other.fParentId && this.fLabels.equals(other.fLabels);
    }

    public int hashCode() {
        return Objects.hash(this.fId, this.fParentId, this.fLabels);
    }

    public String toString() {
        return "<name=" + this.fLabels + " id=" + this.fId + " parentId=" + this.fParentId + ">";
    }
}

