/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.set.primitive;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.set.MutableSet;

/**
 * This file was automatically generated from template file mutablePrimitiveSet.stg.
 *
 * @since 3.0.
 */
public interface MutableLongSet extends MutableLongCollection, LongSet
{
    MutableLongSet select(LongPredicate predicate);

    MutableLongSet reject(LongPredicate predicate);

    <V> MutableSet<V> collect(LongToObjectFunction<? extends V> function);

    MutableLongSet with(long element);

    MutableLongSet without(long element);

    MutableLongSet withAll(LongIterable elements);

    MutableLongSet withoutAll(LongIterable elements);

    MutableLongSet asUnmodifiable();

    MutableLongSet asSynchronized();

    /**
     * Returns a frozen copy of this set. A frozen copy is the same thing as an immutable copy without safe-publish guarantees.
     */
    LongSet freeze();

    /**
     * Returns an immutable copy of this set.
     */
    ImmutableLongSet toImmutable();
}
