/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.internal.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.virgo.ide.ui.internal.actions.AbstractConvertAction;
import org.eclipse.virgo.ide.ui.internal.actions.Messages;

public class ConvertPlugInProject
extends AbstractConvertAction
implements IObjectActionDelegate {
    private static final String PDE_NATURE = "org.eclipse.pde.PluginNature";

    protected String getNature() {
        return PDE_NATURE;
    }

    protected void migrate(IProgressMonitor monitor, IProject project) {
        monitor.beginTask("", 1);
        try {
            try {
                IProjectDescription description = project.getDescription();
                String[] natures = description.getNatureIds();
                String[] newNatures = new String[natures.length + 3];
                System.arraycopy(natures, 0, newNatures, 0, natures.length);
                newNatures[natures.length] = "org.eclipse.wst.common.project.facet.core.nature";
                newNatures[natures.length + 1] = "org.eclipse.virgo.ide.facet.core.bundlenature";
                newNatures[natures.length + 2] = "org.eclipse.virgo.ide.pde.core.nature";
                description.setNatureIds(newNatures);
                project.setDescription(description, monitor);
            }
            catch (CoreException e) {
                Status s = new Status(4, "org.eclipse.virgo.ide.ui", e.getMessage());
                StatusManager.getManager().handle((IStatus)s, 2);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    protected boolean showConfirmationDialog() {
        return MessageDialog.openQuestion((Shell)this.part.getSite().getShell(), (String)Messages.ConvertPlugInProject_title, (String)Messages.ConvertPlugInProject_message);
    }
}

