/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.shell.internal.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiExportPackage;
import org.eclipse.virgo.kernel.shell.Command;
import org.eclipse.virgo.kernel.shell.internal.commands.AbstractInstallArtifactBasedCommands;
import org.eclipse.virgo.kernel.shell.internal.formatting.PackageCommandFormatter;
import org.eclipse.virgo.kernel.shell.state.QuasiPackage;
import org.eclipse.virgo.kernel.shell.state.StateService;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Command(value="package")
public final class PackageCommands {
    private final StateService stateService;
    private final PackageCommandFormatter formatter;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public PackageCommands(StateService stateService) {
        this.stateService = stateService;
        this.formatter = new PackageCommandFormatter();
    }

    @Command(value="list")
    public List<String> list() {
        try {
            PackageCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            List<String> list = this.formatter.formatList(this.getAllPackages());
            PackageCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return list;
        }
        catch (Throwable throwable) {
            PackageCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    @Command(value="examine")
    public List<String> examine(String name, String versionString) {
        try {
            List<String> list;
            block5: {
                Version version;
                PackageCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
                ArrayList<QuasiExportPackage> matchingExports = new ArrayList<QuasiExportPackage>();
                try {
                    version = AbstractInstallArtifactBasedCommands.convertToVersion(versionString);
                }
                catch (IllegalArgumentException iae) {
                    list = Arrays.asList(iae.getMessage());
                    break block5;
                }
                QuasiPackage packages = this.stateService.getPackages(null, name);
                for (QuasiExportPackage exportPackage : packages.getExporters()) {
                    if (!exportPackage.getVersion().equals((Object)version)) continue;
                    matchingExports.add(exportPackage);
                }
                list = matchingExports.isEmpty() ? Arrays.asList(String.format("No package with name '%s' and version '%s' was found", name, version)) : this.formatter.formatExamine(matchingExports);
            }
            PackageCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
            return list;
        }
        catch (Throwable throwable) {
            PackageCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private List<QuasiExportPackage> getAllPackages() {
        ArrayList<QuasiExportPackage> packages = new ArrayList<QuasiExportPackage>();
        for (QuasiBundle bundle : this.stateService.getAllBundles(null)) {
            packages.addAll(bundle.getExportPackages());
        }
        return packages;
    }

    static {
        Factory factory = new Factory("PackageCommands.java", Class.forName("org.eclipse.virgo.kernel.shell.internal.commands.PackageCommands"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "list", "org.eclipse.virgo.kernel.shell.internal.commands.PackageCommands", "", "", "", "java.util.List"), 41);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "examine", "org.eclipse.virgo.kernel.shell.internal.commands.PackageCommands", "java.lang.String:java.lang.String:", "name:versionString:", "", "java.util.List"), 46);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.shell.internal.commands.PackageCommands");
    }
}

