/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.internal.watched;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.management.JMException;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.repository.ArtifactDescriptorPersister;
import org.eclipse.virgo.repository.DuplicateArtifactException;
import org.eclipse.virgo.repository.IndexFormatException;
import org.eclipse.virgo.repository.RepositoryAwareArtifactDescriptor;
import org.eclipse.virgo.repository.RepositoryCreationException;
import org.eclipse.virgo.repository.configuration.WatchedStorageRepositoryConfiguration;
import org.eclipse.virgo.repository.internal.LocalRepository;
import org.eclipse.virgo.repository.internal.RepositoryLogEvents;
import org.eclipse.virgo.repository.internal.management.StandardWatchedStorageRepositoryInfo;
import org.eclipse.virgo.repository.internal.persistence.NoOpArtifactDescriptorPersister;
import org.eclipse.virgo.repository.internal.watched.WatchableRepository;
import org.eclipse.virgo.repository.management.RepositoryInfo;
import org.eclipse.virgo.util.io.FileSystemChecker;
import org.eclipse.virgo.util.io.FileSystemEvent;
import org.eclipse.virgo.util.io.FileSystemListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WatchedStorageRepository
extends LocalRepository
implements WatchableRepository {
    private static final Logger LOGGER;
    private static final String EXCLUDE_PATTERN = "\\.DS_Store";
    private final DirectoryWatcher dirWatcher;
    private final ScheduledExecutorService executorService;
    private final int watchInterval;
    private final File watchDirectory;
    private final EventLogger eventLogger;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.repository.internal.watched.WatchedStorageRepository");
        LOGGER = LoggerFactory.getLogger(WatchedStorageRepository.class);
    }

    public WatchedStorageRepository(WatchedStorageRepositoryConfiguration configuration, EventLogger eventLogger) throws RepositoryCreationException, IndexFormatException {
        this(configuration, (ArtifactDescriptorPersister)new NoOpArtifactDescriptorPersister(), eventLogger);
    }

    public WatchedStorageRepository(WatchedStorageRepositoryConfiguration configuration, ArtifactDescriptorPersister artifactDescriptorPersister, EventLogger eventLogger) throws RepositoryCreationException, IndexFormatException {
        super(configuration, artifactDescriptorPersister, eventLogger);
        this.eventLogger = eventLogger;
        this.watchDirectory = configuration.getDirectoryToWatch();
        this.dirWatcher = new DirectoryWatcher(this.watchDirectory);
        this.watchInterval = configuration.getWatchInterval();
        this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactory(){
            private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                return thread;
            }

            public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
                return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
            }

            static {
                ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.repository.internal.watched.WatchedStorageRepository$1");
            }
        });
    }

    @Override
    public void start() {
        super.start();
        LOGGER.info("Starting to watch directory '{}'; period {}s.", (Object)this.watchDirectory, (Object)this.watchInterval);
        this.dirWatcher.fsChecker.check();
        this.executorService.scheduleAtFixedRate(this.dirWatcher, this.watchInterval, this.watchInterval, TimeUnit.SECONDS);
    }

    @Override
    public void stop() {
        LOGGER.info("Stopping watched directory '{}'.", (Object)this.watchDirectory);
        this.executorService.shutdown();
        super.stop();
    }

    @Override
    protected RepositoryInfo createMBean() throws JMException {
        return new StandardWatchedStorageRepositoryInfo(this.getName(), this.getDepository(), this);
    }

    @Override
    public void forceCheck() throws Exception {
        this.dirWatcher.forceNewCheck();
    }

    @Override
    public Set<String> getArtifactLocations(String filename) {
        HashSet<String> locations = new HashSet<String>(1);
        locations.add(new File(this.watchDirectory, filename).getAbsolutePath());
        return locations;
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    private final class DirectoryWatcher
    implements Runnable {
        private final FileSystemChecker fsChecker;
        private final FileSystemListener listener;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

        private DirectoryWatcher(File directory) throws RepositoryCreationException {
            this.establishDirectory(directory);
            this.fsChecker = new FileSystemChecker(directory, WatchedStorageRepository.EXCLUDE_PATTERN);
            this.listener = new FileSystemListener(){
                private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

                public void onChange(String path, FileSystemEvent event) {
                    File file = new File(path);
                    try {
                        LOGGER.debug("Listener for '{}' heard event '{}' on file '{}'.", new Object[]{WatchedStorageRepository.this.watchDirectory, event, file});
                        switch (event) {
                            case INITIAL: 
                            case CREATED: {
                                RepositoryAwareArtifactDescriptor artifactDescriptor = WatchedStorageRepository.this.createArtifactDescriptor(file);
                                if (artifactDescriptor == null) break;
                                WatchedStorageRepository.this.getDepository().addArtifactDescriptor(artifactDescriptor);
                                break;
                            }
                            case DELETED: {
                                WatchedStorageRepository.this.getDepository().removeArtifactDescriptor(file.toURI());
                                break;
                            }
                            case MODIFIED: {
                                WatchedStorageRepository.this.getDepository().removeArtifactDescriptor(file.toURI());
                                RepositoryAwareArtifactDescriptor artifactDescriptor = WatchedStorageRepository.this.createArtifactDescriptor(file);
                                if (artifactDescriptor == null) break;
                                WatchedStorageRepository.this.getDepository().addArtifactDescriptor(artifactDescriptor);
                            }
                        }
                        WatchedStorageRepository.this.getDepository().persist();
                    }
                    catch (DuplicateArtifactException duplicateArtifactException) {
                        LOGGER.warn("Duplicate artifact in file '{}' detected in watched directory '{}'.", (Object)file, (Object)WatchedStorageRepository.this.watchDirectory);
                    }
                    catch (IOException e) {
                        LOGGER.error(String.format("Watched directory '%s' failed during persist. Stopping repository.", WatchedStorageRepository.this.watchDirectory), (Throwable)e);
                        WatchedStorageRepository.this.stop();
                        WatchedStorageRepository.this.eventLogger.log((LogEvent)RepositoryLogEvents.REPOSITORY_NOT_AVAILABLE, (Throwable)e, new Object[]{WatchedStorageRepository.this.getName()});
                    }
                }

                public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
                    return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
                }

                static {
                    ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.repository.internal.watched.WatchedStorageRepository$DirectoryWatcher$1");
                }
            };
            this.fsChecker.addListener(this.listener);
        }

        public void run() {
            try {
                this.fsChecker.check();
            }
            catch (Exception e) {
                LOGGER.error("File system watcher for repository '{}' failed. Repository stopped.", (Object)WatchedStorageRepository.this.getName());
                WatchedStorageRepository.this.stop();
                WatchedStorageRepository.this.eventLogger.log((LogEvent)RepositoryLogEvents.REPOSITORY_NOT_AVAILABLE, (Throwable)e, new Object[]{WatchedStorageRepository.this.getName()});
            }
        }

        private final void establishDirectory(File dir) throws RepositoryCreationException {
            if (dir.exists() && !dir.isDirectory()) {
                if (!dir.delete()) {
                    LOGGER.error("Directory '{}' for watched repository '{}' is already a file and cannot be deleted. Repository unavailable.", (Object)dir.getName(), (Object)WatchedStorageRepository.this.getName());
                    throw new RepositoryCreationException("Failed to delete index file for repository '" + WatchedStorageRepository.this.getName() + "'");
                }
                LOGGER.debug("File '{}' deleted to create directory for watched repository '{}'.", (Object)dir, (Object)WatchedStorageRepository.this.getName());
            }
            if (!dir.exists() && !dir.mkdirs()) {
                LOGGER.error("Directory '{}' for watched repository '{}' cannot be created. Repository unavailable.", (Object)dir.getName(), (Object)WatchedStorageRepository.this.getName());
                throw new RepositoryCreationException("Failed to delete index file for repository '" + WatchedStorageRepository.this.getName() + "'");
            }
        }

        public void forceNewCheck() throws Exception {
            try {
                this.fsChecker.check();
                this.fsChecker.check();
            }
            catch (Exception e) {
                LOGGER.warn("Directory check for repository '{}' failed.", (Object)WatchedStorageRepository.this.getName());
                throw e;
            }
        }

        public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
            return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        }

        static {
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.repository.internal.watched.WatchedStorageRepository$DirectoryWatcher");
        }
    }
}

