/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.manager;

import java.io.Serializable;
import java.util.Arrays;
import javax.transaction.xa.Xid;

public class XidImpl
implements Xid,
Serializable {
    private static int FORMAT_ID = 1197822575;
    private final int formatId;
    private final byte[] globalId;
    private final byte[] branchId;
    private int hash;

    public XidImpl(byte[] globalId) {
        this.formatId = FORMAT_ID;
        this.globalId = globalId;
        this.branchId = new byte[64];
        this.check();
    }

    private void check() {
        if (this.globalId.length > 64) {
            throw new IllegalStateException("Global id is too long: " + this.toString());
        }
        if (this.branchId.length > 64) {
            throw new IllegalStateException("Branch id is too long: " + this.toString());
        }
    }

    public XidImpl(Xid global, byte[] branch) {
        this.formatId = FORMAT_ID;
        this.globalId = global instanceof XidImpl ? ((XidImpl)global).globalId : global.getGlobalTransactionId();
        this.branchId = branch;
        this.check();
    }

    public XidImpl(int formatId, byte[] globalId, byte[] branchId) {
        this.formatId = formatId;
        this.globalId = globalId;
        this.branchId = branchId;
        this.check();
    }

    private int hash(int hash, byte[] id) {
        for (int i = 0; i < id.length; ++i) {
            hash = hash * 37 + id[i];
        }
        return hash;
    }

    public int getFormatId() {
        return this.formatId;
    }

    public byte[] getGlobalTransactionId() {
        return (byte[])this.globalId.clone();
    }

    public byte[] getBranchQualifier() {
        return (byte[])this.branchId.clone();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof XidImpl)) {
            return false;
        }
        XidImpl other = (XidImpl)obj;
        return this.formatId == other.formatId && Arrays.equals(this.globalId, other.globalId) && Arrays.equals(this.branchId, other.branchId);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.hash(this.hash(0, this.globalId), this.branchId);
        }
        return this.hash;
    }

    public String toString() {
        int i;
        StringBuilder s = new StringBuilder();
        s.append("[Xid:globalId=");
        for (i = 0; i < this.globalId.length; ++i) {
            s.append(Integer.toHexString(this.globalId[i]));
        }
        s.append(",length=").append(this.globalId.length);
        s.append(",branchId=");
        for (i = 0; i < this.branchId.length; ++i) {
            s.append(Integer.toHexString(this.branchId[i]));
        }
        s.append(",length=");
        s.append(this.branchId.length);
        s.append("]");
        return s.toString();
    }
}

