/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.internal.chain;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.repository.Query;
import org.eclipse.virgo.repository.Repository;
import org.eclipse.virgo.repository.RepositoryAwareArtifactDescriptor;
import org.eclipse.virgo.repository.internal.RepositoryUtils;
import org.eclipse.virgo.repository.internal.chain.ChainedQuery;
import org.eclipse.virgo.util.osgi.manifest.VersionRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChainedRepository
implements Repository {
    private static final Logger LOGGER;
    private final List<Repository> repositories;
    private final String name;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.repository.internal.chain.ChainedRepository");
        LOGGER = LoggerFactory.getLogger(ChainedRepository.class);
    }

    public ChainedRepository(String name, List<Repository> repositories) {
        this.name = name;
        this.repositories = repositories;
    }

    @Override
    public Query createQuery(String key, String value) {
        ArrayList<Query> queries = new ArrayList<Query>();
        for (Repository repository : this.repositories) {
            queries.add(repository.createQuery(key, value));
        }
        return new ChainedQuery(queries);
    }

    @Override
    public Query createQuery(String key, String value, Map<String, Set<String>> properties) {
        ArrayList<Query> queries = new ArrayList<Query>();
        for (Repository repository : this.repositories) {
            queries.add(repository.createQuery(key, value, properties));
        }
        return new ChainedQuery(queries);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RepositoryAwareArtifactDescriptor get(String type, String name, VersionRange versionRange) {
        HashSet<RepositoryAwareArtifactDescriptor> artifacts = new HashSet<RepositoryAwareArtifactDescriptor>();
        for (Repository repository : this.repositories) {
            RepositoryAwareArtifactDescriptor artifact = repository.get(type, name, versionRange);
            if (artifact == null) continue;
            artifacts.add(artifact);
        }
        LOGGER.debug("Chain returned {} artifacts named '{}' in version range '{}'.", new Object[]{artifacts.size(), name, versionRange});
        return (RepositoryAwareArtifactDescriptor)RepositoryUtils.selectHighestVersion(artifacts);
    }

    @Override
    public void stop() {
        for (Repository repository : this.repositories) {
            repository.stop();
        }
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }
}

